/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.vectortiles;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.atlas.exception.CoreException;

public enum MinimumZoom {
    INSTANCE;

    private static final String CONFIG_RESOURCE = "minimum-zooms.json";
    private static final int DEFAULT_ZOOM = 14;
    private String[] keys;
    private int[] defaults;
    private List<Map<String, Integer>> valuesList = new ArrayList<Map<String, Integer>>();

    private MinimumZoom() {
        this.processConfig(this.parseConfig());
    }

    private JsonArray parseConfig() {
        try {
            InputStream inputStream = MinimumZoom.class.getResourceAsStream(CONFIG_RESOURCE);
            InputStreamReader reader = new InputStreamReader(inputStream);
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse(reader);
            return element.getAsJsonArray();
        }
        catch (Exception exception) {
            throw new CoreException("There was a problem parsing minimum-zooms.json. Check if the JSON file has valid structure.", exception);
        }
    }

    private void processConfig(JsonArray config) {
        int length = config.size();
        this.keys = new String[length];
        this.defaults = new int[length];
        for (int index = 0; index < length; ++index) {
            try {
                JsonObject object = config.get(index).getAsJsonObject();
                this.keys[index] = object.get("key").getAsString();
                this.defaults[index] = object.get("default").getAsInt();
                HashMap valuesMap = new HashMap();
                this.valuesList.add(index, valuesMap);
                JsonElement valuesElement = object.get("values");
                if (valuesElement == null) continue;
                valuesElement.getAsJsonObject().entrySet().forEach(entry -> valuesMap.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt()));
                continue;
            }
            catch (Exception exception) {
                throw new CoreException("There is a problem with one of the rule objects in the JSON configuration.", exception);
            }
        }
    }

    public int get(Map<String, String> tags) {
        for (int index = 0; index < this.keys.length; ++index) {
            String key = this.keys[index];
            String value = tags.get(key);
            if (value == null) continue;
            Map<String, Integer> valuesMap = this.valuesList.get(index);
            Integer valueMinimumZoom = valuesMap.get(value);
            if (valueMinimumZoom != null) {
                return valueMinimumZoom;
            }
            return this.defaults[index];
        }
        return 14;
    }
}

