/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.tuples;

import java.io.Serializable;
import java.util.function.Consumer;

public final class Either<L, R>
implements Serializable {
    private static final long serialVersionUID = 158343315469036806L;
    private final L left;
    private final R right;

    public static <L, R> Either<L, R> left(L value) {
        return new Either<L, Object>(value, null);
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Either<Object, R>(null, value);
    }

    private Either(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public void apply(Consumer<? super L> leftFunction, Consumer<? super R> rightFunction) {
        if (this.left != null) {
            leftFunction.accept(this.left);
        } else if (this.right != null) {
            rightFunction.accept(this.right);
        }
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }
}

