/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.statistic.storeless;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.statistic.AbstractStatistic;
import org.openstreetmap.atlas.utilities.statistic.storeless.StatisticType;
import org.slf4j.Logger;

public class CustomizedStatistic
extends AbstractStatistic {
    private final Map<StatisticType, StorelessUnivariateStatistic> statistics = new HashMap<StatisticType, StorelessUnivariateStatistic>();

    public CustomizedStatistic(Logger logger, long logFrequency, StatisticType ... types) {
        super(logger, logFrequency);
        this.configure(types);
    }

    public CustomizedStatistic(Logger logger, StatisticType ... types) {
        super(logger);
        this.configure(types);
    }

    public double getGeometricMean() {
        if (this.statistics.containsKey((Object)StatisticType.GeometricMean)) {
            return this.statistics.get((Object)StatisticType.GeometricMean).getResult();
        }
        throw new CoreException("You didn't choose the statistic type GeometricMean");
    }

    public double getKurtosis() {
        if (this.statistics.containsKey((Object)StatisticType.Kurtosis)) {
            return this.statistics.get((Object)StatisticType.Kurtosis).getResult();
        }
        throw new CoreException("You didn't choose the statistic type Kurtosis");
    }

    public double getMax() {
        if (this.statistics.containsKey((Object)StatisticType.Max)) {
            return this.statistics.get((Object)StatisticType.Max).getResult();
        }
        throw new CoreException("You didn't choose the statistic type Max");
    }

    public double getMean() {
        if (this.statistics.containsKey((Object)StatisticType.Mean)) {
            return this.statistics.get((Object)StatisticType.Mean).getResult();
        }
        throw new CoreException("You didn't choose the statistic type Mean");
    }

    public double getMin() {
        if (this.statistics.containsKey((Object)StatisticType.Min)) {
            return this.statistics.get((Object)StatisticType.Min).getResult();
        }
        throw new CoreException("You didn't choose the statistic type Min");
    }

    public double getProduct() {
        if (this.statistics.containsKey((Object)StatisticType.Product)) {
            return this.statistics.get((Object)StatisticType.Product).getResult();
        }
        throw new CoreException("You didn't choose the statistic type Product");
    }

    public double getSecondMoment() {
        if (this.statistics.containsKey((Object)StatisticType.SecondMoment)) {
            return this.statistics.get((Object)StatisticType.SecondMoment).getResult();
        }
        throw new CoreException("You didn't choose the statistic type SecondMoment");
    }

    public double getSkewness() {
        if (this.statistics.containsKey((Object)StatisticType.Skewness)) {
            return this.statistics.get((Object)StatisticType.Skewness).getResult();
        }
        throw new CoreException("You didn't choose the statistic type Skewness");
    }

    public double getStandardDeviation() {
        if (this.statistics.containsKey((Object)StatisticType.StandardDeviation)) {
            return this.statistics.get((Object)StatisticType.StandardDeviation).getResult();
        }
        throw new CoreException("You didn't choose the statistic type StandardDeviation");
    }

    public double getSum() {
        if (this.statistics.containsKey((Object)StatisticType.Sum)) {
            return this.statistics.get((Object)StatisticType.Sum).getResult();
        }
        throw new CoreException("You didn't choose the statistic type Sum");
    }

    public double getSumOfLogs() {
        if (this.statistics.containsKey((Object)StatisticType.SumOfLogs)) {
            return this.statistics.get((Object)StatisticType.SumOfLogs).getResult();
        }
        throw new CoreException("You didn't choose the statistic type SumOfLogs");
    }

    public double getSumOfSquares() {
        if (this.statistics.containsKey((Object)StatisticType.SumOfSquares)) {
            return this.statistics.get((Object)StatisticType.SumOfSquares).getResult();
        }
        throw new CoreException("You didn't choose the statistic type SumOfSquares");
    }

    public long getTotal() {
        if (this.statistics.size() > 0) {
            return this.statistics.entrySet().iterator().next().getValue().getN();
        }
        return 0L;
    }

    public double getVariance() {
        if (this.statistics.containsKey((Object)StatisticType.Variance)) {
            return this.statistics.get((Object)StatisticType.Variance).getResult();
        }
        throw new CoreException("You didn't choose the statistic type Variance");
    }

    @Override
    public void onIncrement(double value) {
        for (StorelessUnivariateStatistic stat : this.statistics.values()) {
            stat.increment(value);
        }
    }

    @Override
    public void summary() {
        this.getLog().accept(this.toString());
        this.statistics.forEach((type, statistic) -> this.getLog().accept(type.name() + ": " + statistic.getResult()));
    }

    @Override
    protected void onIncrement() {
    }

    private void configure(StatisticType ... types) {
        for (StatisticType type : types) {
            this.statistics.put(type, type.toStatistic());
        }
    }
}

