/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.statistic;

import java.util.Collection;
import java.util.DoubleSummaryStatistics;
import java.util.IntSummaryStatistics;
import java.util.LongSummaryStatistics;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.commons.math3.stat.StatUtils;
import org.openstreetmap.atlas.utilities.scalars.Ratio;

public final class StatisticUtils {
    public static double percentile(Collection<Double> collection, Ratio ratio) {
        double[] array = StatisticUtils.toDoubleArray(collection);
        return StatUtils.percentile(array, ratio.asPercentage());
    }

    public static <T> Optional<T> summarizing(Collection<T> collection, BinaryOperator<T> accumulator) {
        return collection.stream().reduce(accumulator);
    }

    public static DoubleSummaryStatistics summarizingDouble(Collection<Double> collection) {
        return collection.stream().mapToDouble(value -> value).summaryStatistics();
    }

    public static <T> DoubleSummaryStatistics summarizingDouble(Collection<T> collection, ToDoubleFunction<? super T> function) {
        return collection.stream().mapToDouble(function).summaryStatistics();
    }

    public static IntSummaryStatistics summarizingInt(Collection<Integer> collection) {
        return collection.stream().mapToInt(value -> value).summaryStatistics();
    }

    public static <T> IntSummaryStatistics summarizingInt(Collection<T> collection, ToIntFunction<? super T> function) {
        return collection.stream().mapToInt(function).summaryStatistics();
    }

    public static LongSummaryStatistics summarizingLong(Collection<Long> collection) {
        return collection.stream().mapToLong(value -> value).summaryStatistics();
    }

    public static <T> LongSummaryStatistics summarizingLong(Collection<T> collection, ToLongFunction<? super T> function) {
        return collection.stream().mapToLong(function).summaryStatistics();
    }

    private static double[] toDoubleArray(Collection<Double> collection) {
        double[] array = new double[collection.size()];
        int index = 0;
        for (Double element : collection) {
            array[index++] = element;
        }
        return array;
    }

    private StatisticUtils() {
    }
}

