/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.runtime.system.memory;

import org.openstreetmap.atlas.utilities.scalars.Ratio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Memory {
    private static final Logger logger = LoggerFactory.getLogger(Memory.class);
    private static final long BYTES_PER_KILO_BYTE = 1024L;
    private static final long BYTES_PER_MEGA_BYTE = 0x100000L;
    private static final long BYTES_PER_GIGA_BYTE = 0x40000000L;
    private static final long BYTES_PER_TERA_BYTE = 0x10000000000L;
    public static final Memory ZERO = Memory.bytes(0L);
    private final long bytes;

    public static Memory bytes(long bytes) {
        return new Memory(bytes);
    }

    public static Memory free() {
        return Memory.bytes(Runtime.getRuntime().freeMemory());
    }

    public static Memory gigaBytes(double gigaBytes) {
        return Memory.bytes(Math.round(gigaBytes * 1.073741824E9));
    }

    public static Memory kiloBytes(double kiloBytes) {
        return Memory.bytes(Math.round(kiloBytes * 1024.0));
    }

    public static Memory maximum() {
        return Memory.bytes(Runtime.getRuntime().maxMemory());
    }

    public static Memory megaBytes(double megaBytes) {
        return Memory.bytes(Math.round(megaBytes * 1048576.0));
    }

    public static void printCurrentMemory() {
        logger.info("########## Memory utilization statistics ##########");
        logger.info("Ratio Used / Maximum: {}", (Object)Ratio.ratio(Memory.used().asKiloBytes() / Memory.maximum().asKiloBytes()));
        logger.info("Used Memory: {}", (Object)Memory.used());
        logger.info("Free Memory: {}", (Object)Memory.free());
        logger.info("Total Memory: {}", (Object)Memory.total());
        logger.info("Maximum Memory: {}", (Object)Memory.maximum());
        logger.info("###################################################");
    }

    public static Memory teraBytes(double teraBytes) {
        return Memory.bytes(Math.round(teraBytes * 1.099511627776E12));
    }

    public static Memory total() {
        return Memory.bytes(Runtime.getRuntime().totalMemory());
    }

    public static Memory used() {
        Runtime runtime = Runtime.getRuntime();
        long bytes = runtime.totalMemory() - runtime.freeMemory();
        if (bytes < 0L) {
            return ZERO;
        }
        return Memory.bytes(bytes);
    }

    private Memory(long bytes) {
        this.bytes = bytes;
    }

    public long asBytes() {
        return this.bytes;
    }

    public double asGigaBytes() {
        return (double)this.asBytes() / 1.073741824E9;
    }

    public double asKiloBytes() {
        return (double)this.asBytes() / 1024.0;
    }

    public double asMegaBytes() {
        return (double)this.asBytes() / 1048576.0;
    }

    public double asTeraBytes() {
        return (double)this.asBytes() / 1.099511627776E12;
    }

    public String toString() {
        if (this.bytes < 1024L) {
            return this.asBytes() + " bytes";
        }
        if (this.bytes < 0x100000L) {
            return this.format(this.asKiloBytes()) + " Kb";
        }
        if (this.bytes < 0x40000000L) {
            return this.format(this.asMegaBytes()) + " Mb";
        }
        if (this.bytes < 0x10000000000L) {
            return this.format(this.asGigaBytes()) + " Gb";
        }
        return this.format(this.asTeraBytes()) + " Tb";
    }

    private String format(double value) {
        return String.format("%.2f", value);
    }
}

