/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.runtime;

import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.runtime.Retry;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.openstreetmap.atlas.utilities.threads.Pool;

public class TimedRetry {
    private static final String TIMEOUT_MESSAGE = "Timeout Error: ";
    private final int retries;

    public TimedRetry(int retries) {
        this.retries = retries;
    }

    public <Value> Value run(Supplier<Value> callable, Duration timeBeforeRetry) {
        Retry retry = new Retry(this.retries, Duration.ZERO);
        Predicate<Throwable> exceptionsWhichShouldBreakDirectly = error -> !error.getMessage().startsWith(TIMEOUT_MESSAGE);
        return (Value)retry.run(() -> {
            Pool pool = new Pool(1, Thread.currentThread().getName() + " # TimedRetry", timeBeforeRetry.add(Duration.ONE_SECOND));
            try {
                Object object = pool.queue(() -> TimedRetry.lambda$run$1((Supplier)callable)).get(timeBeforeRetry);
                pool.close();
                return object;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        pool.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (TimeoutException e) {
                    throw new CoreException("Timeout Error: Timeout in TimedRetry call", e);
                }
            }
        }, exceptionsWhichShouldBreakDirectly);
    }

    private static /* synthetic */ Object lambda$run$1(Supplier callable) throws Exception {
        return callable.get();
    }
}

