/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.runtime;

import java.net.URL;
import java.net.URLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassPathTree {
    private static final Logger logger = LoggerFactory.getLogger(ClassPathTree.class);

    public static void print(Class<?> target) {
        try {
            ClassLoader loader = target.getClassLoader();
            ClassPathTree.print(loader);
        }
        catch (Exception e) {
            logger.error("Could not print ClassPathTree for {}", target, (Object)e);
        }
    }

    public static void print(String className) {
        try {
            ClassPathTree.print(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            logger.error("Could not print ClassPathTree for {}", (Object)className, (Object)e);
        }
    }

    private static void print(ClassLoader loader) {
        logger.debug("### Classloader Class: {} [{}] ###\n\n", (Object)loader.getClass().getName(), (Object)System.identityHashCode(loader));
        if (loader instanceof URLClassLoader) {
            URL[] urls;
            for (URL url : urls = ((URLClassLoader)loader).getURLs()) {
                logger.debug("* {}\n", (Object)url);
            }
        } else {
            logger.debug("[Not Using URLClassLoader]");
        }
        logger.debug("");
        ClassLoader parent = loader.getParent();
        if (parent != null) {
            ClassPathTree.print(parent);
        }
    }

    private ClassPathTree() {
    }
}

