/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.http.rest;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.http.rest.DislikedResponseCodeException;
import org.openstreetmap.atlas.utilities.tuples.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResultHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpResultHandler.class);
    private static final Consumer<Tuple<Integer, String>> LOGGING_HANDLER = tuple -> logger.debug("[{}] -> {}", tuple.getFirst(), tuple.getSecond());
    private static final Consumer<Tuple<Integer, String>> IGNORE_HANDLER = tuple -> {};
    private static final Consumer<Tuple<Integer, String>> THROW_HANDLER = tuple -> {
        throw new DislikedResponseCodeException((Integer)tuple.getFirst(), (String)tuple.getSecond(), new Object[0]);
    };
    private final Map<Integer, Consumer<Tuple<Integer, String>>> responseHandlers = new HashMap<Integer, Consumer<Tuple<Integer, String>>>();
    private Consumer<Tuple<Integer, String>> defaultHandler = IGNORE_HANDLER;

    public HttpResultHandler abort() {
        this.defaultHandler = THROW_HANDLER;
        return this;
    }

    public HttpResultHandler abort(int statusCode) {
        return this.actOn(statusCode, THROW_HANDLER);
    }

    public HttpResultHandler actOn(int statusCode, Consumer<Tuple<Integer, String>> data) {
        this.responseHandlers.put(statusCode, data);
        return this;
    }

    public HttpResultHandler ignore() {
        this.defaultHandler = IGNORE_HANDLER;
        return this;
    }

    public HttpResultHandler ignore(int statusCode) {
        return this.actOn(statusCode, IGNORE_HANDLER);
    }

    public HttpResultHandler log() {
        this.defaultHandler = LOGGING_HANDLER;
        return this;
    }

    public HttpResultHandler log(int statusCode) {
        return this.actOn(statusCode, LOGGING_HANDLER);
    }

    public void parse(CloseableHttpResponse response) {
        try (StringWriter stringWriter = new StringWriter();){
            IOUtils.copy(response.getEntity().getContent(), (Writer)stringWriter, StandardCharsets.UTF_8);
            int statusCode = response.getStatusLine().getStatusCode();
            stringWriter.flush();
            this.responseHandlers.getOrDefault(statusCode, this.defaultHandler).accept(new Tuple<Integer, String>(statusCode, stringWriter.toString()));
        }
        catch (IOException oops) {
            throw new CoreException("Error when parsing HTTP response body", oops);
        }
    }

    public <T> HttpResultHandler parseJSON(int statusCode, Class<T> conversionClass, Consumer<Tuple<Integer, T>> consumer) {
        return this.actOn(statusCode, item -> {
            try {
                JsonParser parser = new JsonFactory().createParser((String)item.getSecond());
                parser.setCodec(new ObjectMapper());
                consumer.accept(new Tuple(statusCode, parser.readValueAs(conversionClass)));
            }
            catch (Exception oops) {
                throw new CoreException("Error when parsing JSON", oops);
            }
        });
    }
}

