/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.subcommands.templates;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.command.abstractcommand.AbstractAtlasShellToolsCommand;
import org.openstreetmap.atlas.utilities.command.abstractcommand.CommandOutputDelegate;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;

public abstract class MultipleOutputCommand
extends AbstractAtlasShellToolsCommand {
    public static final String OUTPUT_DIRECTORY_OPTION_LONG = "output";
    private static final Character OUTPUT_DIRECTORY_OPTION_SHORT = Character.valueOf('o');
    private static final String OUTPUT_DIRECTORY_OPTION_DESCRIPTION = "Specify an alternate output directory for any output files. If the directory does not exist, it will be created.";
    private static final String OUTPUT_DIRECTORY_OPTION_HINT = "dir";
    private final OptionAndArgumentDelegate optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();
    private final CommandOutputDelegate outputDelegate = this.getCommandOutputDelegate();
    private Path outputPath = null;

    @Override
    public int execute() {
        Optional<Path> outputPathOptional = this.parseOutputPath();
        if (!outputPathOptional.isPresent()) {
            this.outputDelegate.printlnErrorMessage("invalid output path");
            return 1;
        }
        this.outputPath = outputPathOptional.get();
        return 0;
    }

    public Path getOutputPath() {
        return this.outputPath;
    }

    @Override
    public void registerManualPageSections() {
        this.addManualPageSection("MULTIPLE OUTPUT", MultipleOutputCommand.class.getResourceAsStream("MultipleOutputCommandSection.txt"));
    }

    @Override
    public void registerOptionsAndArguments() {
        Integer[] contexts = this.optionAndArgumentDelegate.getFilteredRegisteredContexts().toArray(new Integer[0]);
        this.registerOptionWithRequiredArgument(OUTPUT_DIRECTORY_OPTION_LONG, OUTPUT_DIRECTORY_OPTION_SHORT, OUTPUT_DIRECTORY_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, OUTPUT_DIRECTORY_OPTION_HINT, contexts);
        super.registerOptionsAndArguments();
    }

    private Optional<Path> parseOutputPath() {
        Path outputParentPath = Paths.get(this.optionAndArgumentDelegate.getOptionArgument(OUTPUT_DIRECTORY_OPTION_LONG).orElse(""), new String[0]);
        if (outputParentPath.toAbsolutePath().toFile().isFile()) {
            this.outputDelegate.printlnErrorMessage(outputParentPath.toString() + " already exists and is a file");
            return Optional.empty();
        }
        if (!outputParentPath.toAbsolutePath().toFile().exists()) {
            try {
                new File(outputParentPath.toAbsolutePath().toString()).mkdirs();
            }
            catch (Exception exception) {
                this.outputDelegate.printlnErrorMessage("failed to create output directory " + outputParentPath.toString());
                return Optional.empty();
            }
        }
        if (!outputParentPath.toAbsolutePath().toFile().canWrite()) {
            this.outputDelegate.printlnErrorMessage(outputParentPath.toString() + " is not writable");
            return Optional.empty();
        }
        return Optional.ofNullable(outputParentPath);
    }
}

