/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.subcommands;

import java.util.List;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.utilities.command.abstractcommand.AbstractAtlasShellToolsCommand;
import org.openstreetmap.atlas.utilities.command.abstractcommand.CommandOutputDelegate;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentArity;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentOptionality;
import org.openstreetmap.atlas.utilities.command.terminal.TTYAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardToBoundsCommand
extends AbstractAtlasShellToolsCommand {
    private static final Logger logger = LoggerFactory.getLogger(ShardToBoundsCommand.class);
    private static final String INPUT_SHARDS = "shards";
    private final OptionAndArgumentDelegate optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();
    private final CommandOutputDelegate outputDelegate = this.getCommandOutputDelegate();

    public static void main(String[] args) {
        new ShardToBoundsCommand().runSubcommandAndExit(args);
    }

    @Override
    public int execute() {
        List<String> shards = this.optionAndArgumentDelegate.getVariadicArgument(INPUT_SHARDS);
        for (int i = 0; i < shards.size(); ++i) {
            String shard = shards.get(i);
            this.parseShardAndPrintOutput(shard);
            if (i >= shards.size() - 1) continue;
            this.outputDelegate.printlnStdout("", new TTYAttribute[0]);
        }
        return 0;
    }

    @Override
    public String getCommandName() {
        return "shard-bounds";
    }

    @Override
    public String getSimpleDescription() {
        return "get the WKT bounds of given shard(s)";
    }

    @Override
    public void registerManualPageSections() {
        this.addManualPageSection("DESCRIPTION", ShardToBoundsCommand.class.getResourceAsStream("ShardToBoundsCommandDescriptionSection.txt"));
        this.addManualPageSection("EXAMPLES", ShardToBoundsCommand.class.getResourceAsStream("ShardToBoundsCommandExamplesSection.txt"));
    }

    @Override
    public void registerOptionsAndArguments() {
        this.registerArgument(INPUT_SHARDS, ArgumentArity.VARIADIC, ArgumentOptionality.REQUIRED, new Integer[0]);
        super.registerOptionsAndArguments();
    }

    private void parseShardAndPrintOutput(String shard) {
        SlippyTile tile;
        this.outputDelegate.printlnStdout(shard + " bounds: ", TTYAttribute.BOLD);
        try {
            tile = SlippyTile.forName(shard);
        }
        catch (Exception exception) {
            logger.error("unable to parse {}", (Object)shard, (Object)exception);
            return;
        }
        this.outputDelegate.printlnStdout(tile.bounds().toWkt(), TTYAttribute.GREEN);
    }
}

