/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.subcommands;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasCloner;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.collections.Sets;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.command.abstractcommand.CommandOutputDelegate;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;
import org.openstreetmap.atlas.utilities.command.subcommands.templates.AtlasLoaderCommand;
import org.openstreetmap.atlas.utilities.command.terminal.TTYAttribute;

public class IdentifierSearchCommand
extends AtlasLoaderCommand {
    private static final String ID_OPTION_LONG = "id";
    private static final String ID_OPTION_DESCRIPTION = "A comma separated list of Atlas ids for which to search.";
    private static final String ID_OPTION_HINT = "ids";
    private static final String OSMID_OPTION_LONG = "osmid";
    private static final String OSMID_OPTION_DESCRIPTION = "A comma separated list of OSM ids for which to search.";
    private static final String OSMID_OPTION_HINT = "osmids";
    private static final String OUTPUT_ATLAS = "collected-multi.atlas";
    private static final String COLLECT_OPTION_LONG = "collect-matching";
    private static final String COLLECT_OPTION_DESCRIPTION = "Collect all matching atlas files and save to a file using the MultiAtlas.";
    private static final List<String> ITEM_TYPE_STRINGS = Arrays.stream(ItemType.values()).map(Enum::toString).collect(Collectors.toList());
    private static final String TYPES_OPTION_LONG = "types";
    private static final String TYPES_OPTION_DESCRIPTION = "A comma separated list of ItemTypes by which to narrow the search. Valid types are: " + new StringList(ITEM_TYPE_STRINGS).join(", ") + ". Defaults to including all values.";
    private static final String TYPES_OPTION_HINT = "types";
    private Set<Long> ids;
    private Set<Long> osmIds;
    private Set<ItemType> typesToCheck;
    private Set<Atlas> matchingAtlases;
    private final OptionAndArgumentDelegate optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();
    private final CommandOutputDelegate outputDelegate = this.getCommandOutputDelegate();

    public static void main(String[] args) {
        new IdentifierSearchCommand().runSubcommandAndExit(args);
    }

    @Override
    public int finish() {
        if (this.optionAndArgumentDelegate.hasOption(COLLECT_OPTION_LONG) && !this.matchingAtlases.isEmpty()) {
            MultiAtlas outputAtlas = new MultiAtlas(this.matchingAtlases);
            Path concatenatedPath = Paths.get(this.getOutputPath().toAbsolutePath().toString(), OUTPUT_ATLAS);
            File outputFile = new File(concatenatedPath.toAbsolutePath().toString());
            new PackedAtlasCloner().cloneFrom(outputAtlas).save(outputFile);
            if (this.optionAndArgumentDelegate.hasVerboseOption()) {
                this.outputDelegate.printlnCommandMessage("saved to " + concatenatedPath.toString());
            }
        }
        return 0;
    }

    @Override
    public String getCommandName() {
        return "find-id";
    }

    @Override
    public String getSimpleDescription() {
        return "find features with given identifier(s) in given atlas(es)";
    }

    @Override
    public void registerManualPageSections() {
        this.addManualPageSection("DESCRIPTION", IdentifierSearchCommand.class.getResourceAsStream("IdentifierSearchCommandDescriptionSection.txt"));
        this.addManualPageSection("EXAMPLES", IdentifierSearchCommand.class.getResourceAsStream("IdentifierSearchCommandExamplesSection.txt"));
        super.registerManualPageSections();
    }

    @Override
    public void registerOptionsAndArguments() {
        this.registerOptionWithRequiredArgument(ID_OPTION_LONG, ID_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, ID_OPTION_HINT, new Integer[0]);
        this.registerOptionWithRequiredArgument(OSMID_OPTION_LONG, OSMID_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, OSMID_OPTION_HINT, new Integer[0]);
        this.registerOptionWithRequiredArgument("types", TYPES_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, "types", new Integer[0]);
        this.registerOption(COLLECT_OPTION_LONG, COLLECT_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, new Integer[0]);
        super.registerOptionsAndArguments();
    }

    @Override
    public int start() {
        this.ids = this.optionAndArgumentDelegate.getOptionArgument(ID_OPTION_LONG, this::parseIds).orElse(new HashSet());
        this.osmIds = this.optionAndArgumentDelegate.getOptionArgument(OSMID_OPTION_LONG, this::parseIds).orElse(new HashSet());
        this.typesToCheck = this.optionAndArgumentDelegate.getOptionArgument("types", this::parseItemTypes).orElse(Sets.hashSet(ItemType.values()));
        this.matchingAtlases = new HashSet<Atlas>();
        if (this.typesToCheck.isEmpty()) {
            this.outputDelegate.printlnErrorMessage("no ItemTypes were successfully parsed");
            return 1;
        }
        if (this.ids.isEmpty() && this.osmIds.isEmpty()) {
            this.outputDelegate.printlnErrorMessage("no ids were successfully parsed");
            return 1;
        }
        return 0;
    }

    @Override
    protected void processAtlas(Atlas atlas, String atlasFileName, File atlasResource) {
        for (Long atlasId : this.ids) {
            for (ItemType type : this.typesToCheck) {
                AtlasEntity entity = atlas.entity(atlasId, type);
                if (entity == null) continue;
                this.outputDelegate.printlnStdout("Found entity with atlas ID " + atlasId + " in " + atlasResource.getPath() + ":", TTYAttribute.BOLD);
                this.outputDelegate.printlnStdout(entity.toDiffViewFriendlyString(), TTYAttribute.GREEN);
                this.outputDelegate.printlnStdout("", new TTYAttribute[0]);
                this.matchingAtlases.add(atlas);
            }
        }
        for (AtlasEntity entity : atlas.entities()) {
            for (Long osmId : this.osmIds) {
                if (osmId.longValue() != entity.getOsmIdentifier() || !this.typesToCheck.contains((Object)entity.getType())) continue;
                this.outputDelegate.printlnStdout("Found entity with OSM ID " + osmId + " in " + atlasResource.getPath() + ":", TTYAttribute.BOLD);
                this.outputDelegate.printlnStdout(entity.toDiffViewFriendlyString(), TTYAttribute.GREEN);
                this.outputDelegate.printlnStdout("", new TTYAttribute[0]);
                this.matchingAtlases.add(atlas);
            }
        }
    }

    private Set<Long> parseIds(String idString) {
        String[] idStringSplit;
        HashSet<Long> idSet = new HashSet<Long>();
        if (idString.isEmpty()) {
            return idSet;
        }
        for (String idElement : idStringSplit = idString.split(",")) {
            try {
                Long identifier = Long.parseLong(idElement);
                idSet.add(identifier);
            }
            catch (NumberFormatException exception) {
                this.outputDelegate.printlnWarnMessage("could not parse id " + idElement + ": skipping...");
            }
        }
        return idSet;
    }

    private Set<ItemType> parseItemTypes(String typeString) {
        String[] typeStringSplit;
        HashSet<ItemType> typeSet = new HashSet<ItemType>();
        if (typeString.isEmpty()) {
            return typeSet;
        }
        for (String typeElement : typeStringSplit = typeString.split(",")) {
            try {
                ItemType type = ItemType.valueOf(typeElement.toUpperCase());
                typeSet.add(type);
            }
            catch (IllegalArgumentException exception) {
                this.outputDelegate.printlnWarnMessage("could not parse ItemType " + typeElement + ": skipping...");
            }
        }
        return typeSet;
    }
}

