/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.subcommands;

import java.util.Iterator;
import java.util.List;
import org.openstreetmap.atlas.utilities.command.AtlasShellToolsException;
import org.openstreetmap.atlas.utilities.command.abstractcommand.AbstractAtlasShellToolsCommand;
import org.openstreetmap.atlas.utilities.command.abstractcommand.CommandOutputDelegate;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentArity;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentOptionality;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;
import org.openstreetmap.atlas.utilities.command.terminal.TTYAttribute;

public class AtlasShellToolsDemoCommand
extends AbstractAtlasShellToolsCommand {
    private static final int BREAKFAST_CONTEXT = 4;
    private final OptionAndArgumentDelegate optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();
    private final CommandOutputDelegate outputDelegate = this.getCommandOutputDelegate();

    public static void main(String[] args) {
        new AtlasShellToolsDemoCommand().runSubcommandAndExit(args);
    }

    @Override
    public int execute() {
        if (this.optionAndArgumentDelegate.getParserContext() == 4) {
            this.executeBreakfastContext();
        } else {
            this.executeLunchDinnerContext();
        }
        return 0;
    }

    @Override
    public String getCommandName() {
        return "ast-demo";
    }

    @Override
    public String getSimpleDescription() {
        return "a demo of the Atlas Shell Tools subcommand API and features";
    }

    @Override
    public void registerManualPageSections() {
        this.addManualPageSection("DESCRIPTION", AtlasShellToolsDemoCommand.class.getResourceAsStream("AtlasShellToolsDemoCommandDescriptionSection.txt"));
        this.addManualPageSection("EXAMPLES", AtlasShellToolsDemoCommand.class.getResourceAsStream("AtlasShellToolsDemoCommandExamplesSection.txt"));
    }

    @Override
    public void registerOptionsAndArguments() {
        String beerDescription = "Brand of your favorite beer. Currently making this option description really long in order to test out the autoformatting capabilities of the DocumentationFormatter class.";
        this.setVersion("0.0.1");
        this.registerOption("capitalize", Character.valueOf('c'), "Capitalize the foods list.", OptionOptionality.OPTIONAL, new Integer[0]);
        this.registerOptionWithRequiredArgument("beer", "Brand of your favorite beer. Currently making this option description really long in order to test out the autoformatting capabilities of the DocumentationFormatter class.", OptionOptionality.OPTIONAL, "brand", new Integer[0]);
        this.registerOptionWithOptionalArgument("cheese", Character.valueOf('C'), "Use cheese. Defaults to cheddar, but will accept a supplied alternative.", OptionOptionality.OPTIONAL, "type", new Integer[0]);
        this.registerOptionWithRequiredArgument("repeat", Character.valueOf('R'), "Repeat the food list N times.", OptionOptionality.OPTIONAL, "N", new Integer[0]);
        this.registerArgument("favoriteMeal", ArgumentArity.UNARY, ArgumentOptionality.REQUIRED, new Integer[0]);
        this.registerArgument("favoriteFoods", ArgumentArity.VARIADIC, ArgumentOptionality.OPTIONAL, new Integer[0]);
        this.registerOption("breakfast", Character.valueOf('b'), "Use breakfast mode", OptionOptionality.REQUIRED, 4);
        this.registerArgument("favoriteBreakfastFood", ArgumentArity.UNARY, ArgumentOptionality.OPTIONAL, 4);
        super.registerOptionsAndArguments();
    }

    private void executeBreakfastContext() {
        String breakfast = this.optionAndArgumentDelegate.getUnaryArgument("favoriteBreakfastFood").orElse("Default waffles :(");
        this.outputDelegate.printlnStdout("Using special breakfast mode:", new TTYAttribute[0]);
        this.outputDelegate.printlnStdout(breakfast, TTYAttribute.BOLD);
    }

    private void executeLunchDinnerContext() {
        List<String> foods = this.optionAndArgumentDelegate.getVariadicArgument("favoriteFoods");
        String meal = this.optionAndArgumentDelegate.getUnaryArgument("favoriteMeal").orElseThrow(AtlasShellToolsException::new);
        this.outputDelegate.printStdout("I like meal ", new TTYAttribute[0]);
        this.outputDelegate.printStdout(meal, TTYAttribute.MAGENTA, TTYAttribute.BOLD, TTYAttribute.BLINK);
        this.outputDelegate.printlnStdout(" the best", new TTYAttribute[0]);
        boolean repeatDefault = true;
        int repeat = this.optionAndArgumentDelegate.getOptionArgument("repeat", value -> {
            int parsed;
            try {
                parsed = Integer.parseInt(value);
            }
            catch (Exception exception) {
                this.outputDelegate.printlnWarnMessage("failed to parse repeat argument, using default");
                return null;
            }
            return parsed;
        }).orElse(1);
        this.outputDelegate.printlnStdout("Favorite foods are:", new TTYAttribute[0]);
        for (int index = 0; index < repeat; ++index) {
            Iterator<String> iterator = foods.iterator();
            while (iterator.hasNext()) {
                String food;
                String mutableFood = food = iterator.next();
                if (this.optionAndArgumentDelegate.hasOption("capitalize")) {
                    mutableFood = mutableFood.toUpperCase();
                }
                this.outputDelegate.printlnStdout(mutableFood, TTYAttribute.BOLD);
            }
        }
        if (this.optionAndArgumentDelegate.hasOption("cheese")) {
            this.outputDelegate.printlnStdout("Using " + this.optionAndArgumentDelegate.getOptionArgument("cheese").orElse("cheddar") + " cheese", new TTYAttribute[0]);
        }
        if (this.optionAndArgumentDelegate.hasOption("beer")) {
            this.outputDelegate.printlnStdout("Also ordering a beer, " + this.optionAndArgumentDelegate.getOptionArgument("beer").orElseThrow(AtlasShellToolsException::new), new TTYAttribute[0]);
        } else {
            this.outputDelegate.printlnWarnMessage("beer skipped");
        }
        this.outputDelegate.printStderr("Here is a closing stderr message\n", TTYAttribute.UNDERLINE);
    }
}

