/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.parsing.exceptions;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.utilities.command.parsing.SimpleOptionAndArgumentParser;

public class UnknownOptionException
extends Exception {
    private static final long serialVersionUID = 8506034533362610699L;

    private static Optional<String> closestMatchMessage(String option, Set<SimpleOptionAndArgumentParser.SimpleOption> validOptions) {
        Set optionNames = validOptions.stream().map(SimpleOptionAndArgumentParser.SimpleOption::getLongForm).collect(Collectors.toSet());
        String closestOption = null;
        int minimumDistance = Integer.MAX_VALUE;
        for (String optionName : optionNames) {
            int distance = StringUtils.getLevenshteinDistance(option, optionName);
            if (distance >= minimumDistance) continue;
            closestOption = optionName;
            minimumDistance = distance;
        }
        if (closestOption == null) {
            return Optional.empty();
        }
        return Optional.of(", did you mean '" + closestOption + "'?");
    }

    public UnknownOptionException(Character option) {
        super("unknown short option '" + option + "'");
    }

    public UnknownOptionException(String option) {
        super("unknown long option '" + option + "'");
    }

    public UnknownOptionException(String option, Set<SimpleOptionAndArgumentParser.SimpleOption> validOptions) {
        super("unknown long option '" + option + "'" + UnknownOptionException.closestMatchMessage(option, validOptions).orElse(""));
    }
}

