/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.documentation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Optional;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.command.AtlasShellToolsException;

public class PagerHelper {
    private static final String PAGER_ENVIRONMENT_VARIABLE = "PAGER";
    private static final String DEFAULT_PAGER = "less";
    private static final String DEFAULT_PAGER_FLAGS = "-cSRMis";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageString(String string) {
        String pagerVariable = System.getenv(PAGER_ENVIRONMENT_VARIABLE);
        if (pagerVariable != null && !pagerVariable.isEmpty()) {
            System.err.println("TODO: respect for PAGER env var currently unimplemented!");
        }
        Optional<String> pagerProgram = this.callWhichOnPager(DEFAULT_PAGER);
        File temporaryFile = null;
        try {
            temporaryFile = File.temporary();
        }
        catch (Exception exception) {
            System.out.println(string);
            return;
        }
        if (temporaryFile == null) {
            System.out.println(string);
            return;
        }
        temporaryFile.writeAndClose(string);
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(pagerProgram.orElseThrow(AtlasShellToolsException::new), DEFAULT_PAGER_FLAGS, temporaryFile.getAbsolutePath());
            processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
            processBuilder.redirectInput(ProcessBuilder.Redirect.INHERIT);
            Process process = processBuilder.start();
            process.waitFor();
        }
        catch (Exception exception) {
            System.out.println(string);
        }
        finally {
            temporaryFile.delete();
        }
    }

    private Optional<String> callWhichOnPager(String pager) {
        Process process;
        String whichProgram = "which";
        try {
            process = new ProcessBuilder("which", pager).start();
        }
        catch (IOException exception) {
            return Optional.empty();
        }
        InputStream stream = process.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = null;
        try {
            line = reader.readLine();
        }
        catch (IOException exception) {
            return Optional.empty();
        }
        if (line == null || line.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(line);
    }
}

