/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.abstractcommand;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.command.abstractcommand.AtlasShellToolsMarkerInterface;
import org.openstreetmap.atlas.utilities.command.abstractcommand.CommandOutputDelegate;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.documentation.DocumentationFormatter;
import org.openstreetmap.atlas.utilities.command.documentation.DocumentationRegistrar;
import org.openstreetmap.atlas.utilities.command.documentation.PagerHelper;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentArity;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentOptionality;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;
import org.openstreetmap.atlas.utilities.command.parsing.SimpleOptionAndArgumentParser;
import org.openstreetmap.atlas.utilities.command.parsing.exceptions.AmbiguousAbbreviationException;
import org.openstreetmap.atlas.utilities.command.parsing.exceptions.UnknownOptionException;
import org.openstreetmap.atlas.utilities.command.parsing.exceptions.UnparsableContextException;
import org.openstreetmap.atlas.utilities.command.terminal.TTYAttribute;
import org.openstreetmap.atlas.utilities.command.terminal.TTYStringBuilder;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAtlasShellToolsCommand
implements AtlasShellToolsMarkerInterface {
    private static final String LINE_SEPARATOR = "line.separator";
    private static final Logger logger = LoggerFactory.getLogger(AbstractAtlasShellToolsCommand.class);
    private static final String JAVA_COLOR_STDOUT = "___atlas-shell-tools_color_stdout_SPECIALARGUMENT___";
    private static final String JAVA_NO_COLOR_STDOUT = "___atlas-shell-tools_nocolor_stdout_SPECIALARGUMENT___";
    private static final String JAVA_COLOR_STDERR = "___atlas-shell-tools_color_stderr_SPECIALARGUMENT___";
    private static final String JAVA_NO_COLOR_STDERR = "___atlas-shell-tools_nocolor_stderr_SPECIALARGUMENT___";
    private static final String JAVA_USE_PAGER = "___atlas-shell-tools_use_pager_SPECIALARGUMENT___";
    private static final String JAVA_NO_USE_PAGER = "___atlas-shell-tools_no_use_pager_SPECIALARGUMENT___";
    private static final String JAVA_MARKER_SENTINEL = "___atlas-shell-tools_LAST_ARG_MARKER_SENTINEL___";
    private static final int NUMBER_SENTINELS = 5;
    private static final int STDOUT_COLOR_OFFSET = 5;
    private static final int STDERR_COLOR_OFFSET = 4;
    private static final int PAGER_OFFSET = 3;
    private static final int TERMINAL_COLUMN_OFFSET = 2;
    private static final String VERBOSE_OPTION_LONG = "verbose";
    private static final Character VERBOSE_OPTION_SHORT = Character.valueOf('v');
    private static final String VERBOSE_OPTION_DESCRIPTION = "Show verbose output messages.";
    private static final String HELP_OPTION_LONG = "help";
    private static final Character HELP_OPTION_SHORT = Character.valueOf('h');
    private static final String HELP_OPTION_DESCRIPTION = "Show this help menu.";
    private static final String VERSION_OPTION_LONG = "version";
    private static final Character VERSION_OPTION_SHORT = Character.valueOf('V');
    private static final String VERSION_OPTION_DESCRIPTION = "Print the command version and exit.";
    private static final int HELP_OPTION_CONTEXT = 1;
    private static final int VERSION_OPTION_CONTEXT = 2;
    public static final int DEFAULT_CONTEXT = 3;
    private static final int MAXIMUM_ALLOWED_COLUMN = 225;
    private final SimpleOptionAndArgumentParser parser = new SimpleOptionAndArgumentParser();
    private final DocumentationRegistrar registrar = new DocumentationRegistrar();
    private boolean useColorStdout = false;
    private boolean useColorStderr = false;
    private boolean usePager = false;
    private int maximumColumn = 80;
    private String version = "default_version_value";

    SortedSet<Integer> getFilteredRegisteredContexts() {
        Set set = this.parser.getRegisteredContexts().stream().filter(context -> context != 1 && context != 2).collect(Collectors.toSet());
        return new TreeSet<Integer>(set);
    }

    Optional<String> getOptionArgument(String longForm) {
        return this.parser.getOptionArgument(longForm);
    }

    <T> Optional<T> getOptionArgument(String longForm, StringConverter<T> converter) {
        return this.parser.getOptionArgument(longForm, converter);
    }

    int getParserContext() {
        return this.parser.getContext();
    }

    TTYStringBuilder getTTYStringBuilderForStderr() {
        return new TTYStringBuilder(this.useColorStderr);
    }

    TTYStringBuilder getTTYStringBuilderForStdout() {
        return new TTYStringBuilder(this.useColorStdout);
    }

    Optional<String> getUnaryArgument(String hint) {
        return this.parser.getUnaryArgument(hint);
    }

    List<String> getVariadicArgument(String hint) {
        return this.parser.getVariadicArgument(hint);
    }

    boolean hasOption(String longForm) {
        return this.parser.hasOption(longForm);
    }

    boolean hasVerboseOption() {
        return this.parser.hasOption(VERBOSE_OPTION_LONG);
    }

    void printlnCommandMessage(String message) {
        this.printStderr(this.getCommandName() + ": ", new TTYAttribute[0]);
        this.printStderr(message + System.getProperty(LINE_SEPARATOR), new TTYAttribute[0]);
    }

    void printlnErrorMessage(String message) {
        this.printStderr(this.getCommandName() + ": ", new TTYAttribute[0]);
        this.printStderr("error: ", TTYAttribute.BOLD, TTYAttribute.RED);
        this.printStderr(message + System.getProperty(LINE_SEPARATOR), new TTYAttribute[0]);
    }

    void printlnStderr(String string, TTYAttribute ... attributes) {
        TTYStringBuilder builder = this.getTTYStringBuilderForStderr();
        builder.append(string, attributes);
        System.err.println(builder.toString());
    }

    void printlnStdout(String string, TTYAttribute ... attributes) {
        TTYStringBuilder builder = this.getTTYStringBuilderForStdout();
        builder.append(string, attributes);
        System.out.println(builder.toString());
    }

    void printlnWarnMessage(String message) {
        this.printStderr(this.getCommandName() + ": ", new TTYAttribute[0]);
        this.printStderr("warn: ", TTYAttribute.BOLD, TTYAttribute.MAGENTA);
        this.printStderr(message + System.getProperty(LINE_SEPARATOR), new TTYAttribute[0]);
    }

    void printStderr(String string, TTYAttribute ... attributes) {
        TTYStringBuilder builder = this.getTTYStringBuilderForStderr();
        builder.append(string, attributes);
        System.err.print(builder.toString());
    }

    void printStdout(String string, TTYAttribute ... attributes) {
        TTYStringBuilder builder = this.getTTYStringBuilderForStdout();
        builder.append(string, attributes);
        System.out.print(builder.toString());
    }

    public abstract int execute();

    public abstract String getCommandName();

    public abstract String getSimpleDescription();

    public abstract void registerManualPageSections();

    public void registerOptionsAndArguments() {
        this.registerOption(HELP_OPTION_LONG, HELP_OPTION_SHORT, HELP_OPTION_DESCRIPTION, OptionOptionality.REQUIRED, 1);
        this.registerOption(VERSION_OPTION_LONG, VERSION_OPTION_SHORT, VERSION_OPTION_DESCRIPTION, OptionOptionality.REQUIRED, 2);
        this.registerEmptyContext(3);
        Integer[] contexts = this.getFilteredRegisteredContexts().toArray(new Integer[0]);
        this.registerOption(VERBOSE_OPTION_LONG, VERBOSE_OPTION_SHORT, VERBOSE_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, contexts);
    }

    public void throwIfInvalidNameOrDescription() {
        String name = this.getCommandName();
        if (name == null || name.isEmpty()) {
            throw new CoreException("{} command name must not be null or empty", this.getClass().getName());
        }
        String[] split = name.split("\\s+");
        if (split.length > 1) {
            throw new CoreException("{} command name must not contain whitespace", this.getClass().getName());
        }
        for (int index = 0; index < name.length(); ++index) {
            char currentCharacter = name.charAt(index);
            if (Character.isLetterOrDigit(currentCharacter) || currentCharacter == '-' || currentCharacter == '_') continue;
            throw new CoreException("{} command name must only contain letters, digits, hyphens, or underscores", this.getClass().getName());
        }
        String simpleDescription = this.getSimpleDescription();
        if (simpleDescription == null || simpleDescription.isEmpty()) {
            throw new CoreException("{} simple description must not be null or empty", this.getClass().getName());
        }
    }

    protected void addCodeLineToSection(String section, String codeLine) {
        this.registrar.addCodeLineToSection(section, codeLine);
    }

    protected void addManualPageSection(String section) {
        this.registrar.addManualPageSection(section);
    }

    protected void addManualPageSection(String section, InputStream sectionResourceFileStream) {
        this.registrar.addManualPageSection(section, sectionResourceFileStream);
    }

    protected void addParagraphToSection(String section, String paragraph) {
        this.registrar.addParagraphToSection(section, paragraph);
    }

    protected CommandOutputDelegate getCommandOutputDelegate() {
        return new CommandOutputDelegate(this);
    }

    protected OptionAndArgumentDelegate getOptionAndArgumentDelegate() {
        return new OptionAndArgumentDelegate(this);
    }

    protected void registerArgument(String argumentHint, ArgumentArity arity, ArgumentOptionality optionality, Integer ... contexts) {
        if (contexts.length == 0) {
            this.parser.registerArgument(argumentHint, arity, optionality, 3);
        } else {
            this.parser.registerArgument(argumentHint, arity, optionality, contexts);
        }
    }

    protected void registerEmptyContext(int context) {
        this.parser.registerEmptyContext(context);
    }

    protected void registerOption(String longForm, Character shortForm, String description, OptionOptionality optionality, Integer ... contexts) {
        if (contexts.length == 0) {
            this.parser.registerOption(longForm, shortForm, description, optionality, 3);
        } else {
            this.parser.registerOption(longForm, shortForm, description, optionality, contexts);
        }
    }

    protected void registerOption(String longForm, String description, OptionOptionality optionality, Integer ... contexts) {
        if (contexts.length == 0) {
            this.parser.registerOption(longForm, description, optionality, 3);
        } else {
            this.parser.registerOption(longForm, description, optionality, contexts);
        }
    }

    protected void registerOptionWithOptionalArgument(String longForm, Character shortForm, String description, OptionOptionality optionality, String argumentHint, Integer ... contexts) {
        if (contexts.length == 0) {
            this.parser.registerOptionWithOptionalArgument(longForm, shortForm, description, optionality, argumentHint, 3);
        } else {
            this.parser.registerOptionWithOptionalArgument(longForm, shortForm, description, optionality, argumentHint, contexts);
        }
    }

    protected void registerOptionWithOptionalArgument(String longForm, String description, OptionOptionality optionality, String argumentHint, Integer ... contexts) {
        if (contexts.length == 0) {
            this.parser.registerOptionWithOptionalArgument(longForm, description, optionality, argumentHint, 3);
        } else {
            this.parser.registerOptionWithOptionalArgument(longForm, description, optionality, argumentHint, contexts);
        }
    }

    protected void registerOptionWithRequiredArgument(String longForm, Character shortForm, String description, OptionOptionality optionality, String argumentHint, Integer ... contexts) {
        if (contexts.length == 0) {
            this.parser.registerOptionWithRequiredArgument(longForm, shortForm, description, optionality, argumentHint, 3);
        } else {
            this.parser.registerOptionWithRequiredArgument(longForm, shortForm, description, optionality, argumentHint, contexts);
        }
    }

    protected void registerOptionWithRequiredArgument(String longForm, String description, OptionOptionality optionality, String argumentHint, Integer ... contexts) {
        if (contexts.length == 0) {
            this.parser.registerOptionWithRequiredArgument(longForm, description, optionality, argumentHint, 3);
        } else {
            this.parser.registerOptionWithRequiredArgument(longForm, description, optionality, argumentHint, contexts);
        }
    }

    public int runSubcommand(String ... args) {
        this.throwIfInvalidNameOrDescription();
        String[] argsCopy = this.unpackTailSentinelArguments(args);
        if (argsCopy == null) {
            argsCopy = args;
        }
        this.registerOptionsAndArguments();
        this.registerManualPageSections();
        try {
            this.parser.parse(Arrays.asList(argsCopy));
        }
        catch (AmbiguousAbbreviationException | UnknownOptionException | UnparsableContextException exception) {
            this.printlnErrorMessage(exception.getMessage());
            this.printSimpleUsageMenu();
            this.printStderr("Try the '", new TTYAttribute[0]);
            this.printStderr("--help", TTYAttribute.BOLD);
            this.printStderr("' option (e.g. ", new TTYAttribute[0]);
            this.printStderr("atlas " + this.getCommandName() + " --help", TTYAttribute.BOLD);
            this.printlnStderr(") for more info", new TTYAttribute[0]);
            System.exit(1);
        }
        catch (Exception exception) {
            throw new CoreException("unhandled exception", exception);
        }
        logger.debug("Command using context {}", (Object)this.parser.getContext());
        if (this.parser.hasOption(HELP_OPTION_LONG)) {
            if (this.usePager) {
                PagerHelper helper = new PagerHelper();
                helper.pageString(this.getHelpMenu());
            } else {
                this.printlnStdout(this.getHelpMenu(), new TTYAttribute[0]);
            }
            return 0;
        }
        if (this.parser.hasOption(VERSION_OPTION_LONG)) {
            this.printlnStdout(String.format("%s version %s", this.getCommandName(), this.version), new TTYAttribute[0]);
            return 0;
        }
        return this.execute();
    }

    public void runSubcommandAndExit(String ... args) {
        System.exit(this.runSubcommand(args));
    }

    protected void setVersion(String version) {
        this.version = version;
    }

    private String getHelpMenu() {
        String name = this.getCommandName();
        String simpleDescription = this.getSimpleDescription();
        Map<Integer, Set<SimpleOptionAndArgumentParser.SimpleOption>> optionsWithContext = this.parser.getContextToRegisteredOptions();
        Set<SimpleOptionAndArgumentParser.SimpleOption> allOptions = this.parser.getRegisteredOptions();
        TTYStringBuilder builder = this.getTTYStringBuilderForStdout();
        builder.newline();
        DocumentationFormatter.generateTextForNameSection(name, simpleDescription, builder);
        builder.newline();
        DocumentationFormatter.generateTextForSynopsisSection(name, this.maximumColumn, optionsWithContext, this.parser.getRegisteredContexts(), this.parser.getArgumentHintToArity(), this.parser.getArgumentHintToOptionality(), builder);
        builder.newline();
        if (this.registrar.hasDescriptionSection()) {
            DocumentationFormatter.generateTextForGenericSection(this.registrar.getDescriptionHeader(), this.maximumColumn, builder, this.registrar);
            builder.newline();
        }
        DocumentationFormatter.generateTextForOptionsSection(this.maximumColumn, allOptions, builder);
        builder.newline();
        for (String section : this.registrar.getSections()) {
            if (this.registrar.getDescriptionHeader().equals(section)) continue;
            DocumentationFormatter.generateTextForGenericSection(section, this.maximumColumn, builder, this.registrar);
            builder.newline();
        }
        return builder.toString();
    }

    private void printSimpleUsageMenu() {
        String name = this.getCommandName();
        Map<Integer, Set<SimpleOptionAndArgumentParser.SimpleOption>> optionsWithContext = this.parser.getContextToRegisteredOptions();
        TTYStringBuilder builder = this.getTTYStringBuilderForStderr();
        DocumentationFormatter.generateTextForSynopsisSection(name, this.maximumColumn, optionsWithContext, this.parser.getRegisteredContexts(), this.parser.getArgumentHintToArity(), this.parser.getArgumentHintToOptionality(), builder);
        this.printlnStderr(builder.toString(), new TTYAttribute[0]);
    }

    private String[] unpackTailSentinelArguments(String[] args) {
        if (args.length > 0 && JAVA_MARKER_SENTINEL.equals(args[args.length - 1])) {
            String stdoutColorArg = args[args.length - 5];
            String stderrColorArg = args[args.length - 4];
            String usePagerArg = args[args.length - 3];
            String terminalColumnArg = args[args.length - 2];
            if (JAVA_COLOR_STDOUT.equals(stdoutColorArg)) {
                this.useColorStdout = true;
            } else if (JAVA_NO_COLOR_STDOUT.equals(stdoutColorArg)) {
                this.useColorStdout = false;
            }
            if (JAVA_COLOR_STDERR.equals(stderrColorArg)) {
                this.useColorStderr = true;
            } else if (JAVA_NO_COLOR_STDERR.equals(stderrColorArg)) {
                this.useColorStderr = false;
            }
            if (JAVA_USE_PAGER.equals(usePagerArg)) {
                this.usePager = true;
            } else if (JAVA_NO_USE_PAGER.equals(usePagerArg)) {
                this.usePager = false;
            }
            this.maximumColumn = Integer.parseInt(terminalColumnArg);
            if (this.maximumColumn > 225) {
                this.maximumColumn = 225;
            }
            return Arrays.copyOf(args, args.length - 5);
        }
        return null;
    }
}

