/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command;

import com.google.common.base.Objects;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.command.ReflectionUtilities;
import org.openstreetmap.atlas.utilities.command.abstractcommand.AbstractAtlasShellToolsCommand;

public class ActiveModuleIndexWriter {
    private static final String VERBOSE = "--verbose";
    private static final String DELIMITER = Character.toString('\u001e');
    private final boolean useVerbose;
    private final String outputPath;

    public static void main(String[] args) {
        String outputPath = null;
        String verboseFlag = null;
        if (args.length < 1) {
            throw new CoreException("Missing required output path argument");
        }
        if (args.length == 1) {
            outputPath = args[0];
        } else {
            outputPath = args[0];
            verboseFlag = args[1];
        }
        if (Objects.equal(VERBOSE, verboseFlag)) {
            new ActiveModuleIndexWriter(outputPath, true).printLookupTable();
        } else {
            new ActiveModuleIndexWriter(outputPath, false).printLookupTable();
        }
    }

    public ActiveModuleIndexWriter(String outputPath, boolean useVerbose) {
        this.outputPath = outputPath;
        this.useVerbose = useVerbose;
    }

    private void diagnosticIfVerbose(String message) {
        if (this.useVerbose) {
            System.out.println(message);
        }
    }

    private void printLookupTable() {
        Set<AbstractAtlasShellToolsCommand> commands = ReflectionUtilities.getSubcommandInstances();
        HashSet<String> namesWeHaveAlreadySeen = new HashSet<String>();
        try (PrintWriter printWriter = new PrintWriter(new FileWriter(this.outputPath));){
            this.diagnosticIfVerbose("");
            for (AbstractAtlasShellToolsCommand command : commands) {
                String name;
                this.diagnosticIfVerbose("Found command definition in " + command.getClass().getName());
                this.diagnosticIfVerbose("Validating command definition...");
                command.throwIfInvalidNameOrDescription();
                command.registerOptionsAndArguments();
                command.registerManualPageSections();
                this.diagnosticIfVerbose("Generating index entry...");
                StringBuilder builder = new StringBuilder();
                String nameWithSuffix = name = command.getCommandName();
                int uniqueSuffix = 2;
                while (namesWeHaveAlreadySeen.contains(nameWithSuffix)) {
                    nameWithSuffix = name + uniqueSuffix;
                    ++uniqueSuffix;
                }
                name = nameWithSuffix;
                builder.append(name);
                namesWeHaveAlreadySeen.add(name);
                builder.append(DELIMITER);
                builder.append(command.getClass().getName());
                builder.append(DELIMITER);
                builder.append(command.getSimpleDescription());
                printWriter.println(builder.toString());
                this.diagnosticIfVerbose("Command " + command.getCommandName() + " registered OK.");
                this.diagnosticIfVerbose("");
            }
        }
        catch (IOException exception) {
            throw new CoreException("Could not write index", exception);
        }
    }
}

