/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.collections;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openstreetmap.atlas.exception.CoreException;

public final class Sets {
    @SafeVarargs
    public static <T> Set<T> hashSet(T ... elements) {
        HashSet<T> result = new HashSet<T>();
        for (T element : elements) {
            result.add(element);
        }
        return result;
    }

    @SafeVarargs
    public static <T extends Comparable<T>> SortedSet<T> treeSet(T ... elements) {
        TreeSet<T> result = new TreeSet<T>();
        for (T element : elements) {
            result.add(element);
        }
        return result;
    }

    @SafeVarargs
    public static <V> Set<V> withSets(boolean rejectCollisions, Set<V> ... items) {
        if (items.length == 0) {
            return new HashSet();
        }
        if (items.length == 1) {
            return items[0];
        }
        HashSet<V> result = new HashSet<V>();
        for (Set<V> item : items) {
            for (V entry : item) {
                if (rejectCollisions && result.contains(entry)) {
                    throw new CoreException("Cannot merge sets! Collision on element.");
                }
                result.add(entry);
            }
        }
        return result;
    }

    @SafeVarargs
    public static <V> Set<V> withSets(Set<V> ... items) {
        return Sets.withSets(true, items);
    }

    @SafeVarargs
    public static <V> SortedSet<V> withSortedSets(boolean rejectCollisions, SortedSet<V> ... items) {
        if (items.length == 0) {
            return new TreeSet();
        }
        if (items.length == 1) {
            return items[0];
        }
        TreeSet result = new TreeSet();
        for (SortedSet<V> item : items) {
            for (Object entry : item) {
                if (rejectCollisions && result.contains(entry)) {
                    throw new CoreException("Cannot merge sets! Collision on element.");
                }
                result.add(entry);
            }
        }
        return result;
    }

    @SafeVarargs
    public static <V> SortedSet<V> withSortedSets(SortedSet<V> ... items) {
        return Sets.withSortedSets(true, items);
    }

    private Sets() {
    }
}

