/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.collections;

import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.atlas.exception.CoreException;

public final class Maps {
    @SafeVarargs
    public static <T> Map<T, T> hashMap(T ... items) {
        if (items.length % 2 != 0) {
            throw new CoreException("Needs to have an even number of arguments");
        }
        HashMap<T, T> result = new HashMap<T, T>();
        for (int i = 0; i < items.length; i += 2) {
            result.put(items[i], items[i + 1]);
        }
        return result;
    }

    public static Map<String, String> stringMap(String ... items) {
        return Maps.hashMap(items);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> withMaps(boolean rejectCollisions, Map<K, V> ... items) {
        if (items.length == 0) {
            return new HashMap();
        }
        if (items.length == 1) {
            return items[0];
        }
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map<K, V> item : items) {
            for (Map.Entry<K, V> entry : item.entrySet()) {
                if (rejectCollisions && result.containsKey(entry.getKey())) {
                    throw new CoreException("Cannot merge maps! Collision on key.");
                }
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> withMaps(Map<K, V> ... items) {
        return Maps.withMaps(true, items);
    }

    private Maps() {
    }
}

