/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.utilities.collections.FilteredIterable;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.collections.StreamIterable;
import org.openstreetmap.atlas.utilities.collections.SubIterable;

public final class Iterables {
    public static <Type> boolean addAll(Collection<Type> addHere, Iterable<Type> from) {
        int oldSize = addHere.size();
        StreamSupport.stream(from.spliterator(), false).forEach(addHere::add);
        return oldSize < addHere.size();
    }

    public static <Type> Iterable<Type> asIterable(Iterable<Type> types) {
        return () -> types.iterator();
    }

    public static <Type> List<Type> asList(Iterable<Type> types) {
        if (types instanceof List) {
            return (List)types;
        }
        ArrayList result = new ArrayList();
        types.forEach(type -> result.add(type));
        return result;
    }

    public static <Type> List<Type> asList(Type[] types) {
        ArrayList<Type> result = new ArrayList<Type>();
        for (Type type : types) {
            result.add(type);
        }
        return result;
    }

    public static <TypeKey, TypeValue> Map<TypeKey, TypeValue> asMap(Iterable<Map.Entry<TypeKey, TypeValue>> types) {
        HashMap result = new HashMap();
        types.forEach(entry -> result.put(entry.getKey(), entry.getValue()));
        return result;
    }

    public static <Type> Queue<Type> asQueue(Iterable<Type> types) {
        LinkedList result = new LinkedList();
        types.forEach(type -> result.add(type));
        return result;
    }

    public static <Type> Set<Type> asSet(Iterable<Type> types) {
        HashSet result = new HashSet();
        types.forEach(type -> result.add(type));
        return result;
    }

    public static <Type> Set<Type> asSet(Type[] types) {
        HashSet<Type> result = new HashSet<Type>();
        for (Type type : types) {
            result.add(type);
        }
        return result;
    }

    public static <Type> SortedSet<Type> asSortedSet(Iterable<Type> types) {
        TreeSet result = new TreeSet();
        types.forEach(type -> result.add(type));
        return result;
    }

    public static <Type> boolean contains(Iterable<Type> types, Type type) {
        if (types instanceof Collection) {
            return ((Collection)types).contains(type);
        }
        for (Type candidate : types) {
            if (!candidate.equals(type)) continue;
            return true;
        }
        return false;
    }

    public static <Type> long count(Iterable<Type> types, Function<Type, Long> typeCounter) {
        long result = 0L;
        for (Type type : types) {
            result += typeCounter.apply(type).longValue();
        }
        return result;
    }

    public static <Type> Iterable<Type> emptyIterable(Type example) {
        return () -> new Iterator<Type>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Type next() {
                return null;
            }
        };
    }

    public static <Type> boolean equals(Iterable<Type> that, Iterable<Type> other) {
        boolean otherIsNull;
        boolean thatIsNull = that == null;
        boolean bl = otherIsNull = other == null;
        if (thatIsNull || otherIsNull) {
            return thatIsNull && otherIsNull;
        }
        long thatSize = Iterables.size(that);
        if (thatSize != Iterables.size(other)) {
            return false;
        }
        Iterator<Type> thatIterator = that.iterator();
        Iterator<Type> otherIterator = other.iterator();
        while (thatIterator.hasNext()) {
            if (thatIterator.next().equals(otherIterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <Type> Iterable<Type> filter(Iterable<Type> input, Predicate<Type> matcher) {
        return Iterables.filterTranslate(input, item -> item, matcher);
    }

    public static <Type, IdentifierType> FilteredIterable<Type, IdentifierType> filter(Iterable<Type> types, Set<IdentifierType> filterSet, Function<Type, IdentifierType> identifier) {
        return new FilteredIterable<Type, IdentifierType>(types, filterSet, identifier);
    }

    public static <TypeIn, TypeOut> Iterable<TypeOut> filterTranslate(final Iterable<TypeIn> input, final Function<TypeIn, TypeOut> converter, final Predicate<TypeIn> matcher) {
        return new Iterable<TypeOut>(){

            @Override
            public Iterator<TypeOut> iterator() {
                return new Iterator<TypeOut>(){
                    private boolean consumed = true;
                    private final Iterator<TypeIn> iterator;
                    private TypeIn next;
                    private boolean valid;
                    {
                        this.iterator = input.iterator();
                        this.next = null;
                        this.valid = false;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.consumed) {
                            this.next = null;
                            this.valid = false;
                            while (this.iterator.hasNext() && !this.valid) {
                                this.next = this.iterator.next();
                                this.valid = matcher.test(this.next);
                            }
                            this.consumed = false;
                        }
                        return this.valid;
                    }

                    @Override
                    public TypeOut next() {
                        if (this.hasNext()) {
                            this.consumed = true;
                            return converter.apply(this.next);
                        }
                        return null;
                    }
                };
            }

            public void useless() {
            }
        };
    }

    public static <Type> Optional<Type> first(Iterable<Type> types) {
        return Iterables.nth(types, 0L);
    }

    public static <T> Optional<T> firstMatching(Iterable<T> types, Predicate<T> matcher) {
        return Iterables.first(Iterables.filter(types, matcher));
    }

    public static <Type> Iterable<Type> from(final Enumeration<Type> types) {
        return () -> new Iterator<Type>(){

            @Override
            public boolean hasNext() {
                return types.hasMoreElements();
            }

            @Override
            public Type next() {
                return types.nextElement();
            }
        };
    }

    @SafeVarargs
    public static <Type> Iterable<Type> from(Type ... types) {
        return Iterables.asList(types);
    }

    public static <Type> Type head(Iterable<Type> types) {
        Iterator<Type> iterator = types.iterator();
        return iterator.hasNext() ? (Type)iterator.next() : null;
    }

    public static boolean isEmpty(Iterable<?> types) {
        if (types instanceof Collection) {
            return ((Collection)types).isEmpty();
        }
        return !types.iterator().hasNext();
    }

    public static <Type> Iterable<Type> iterable(final Type ... types) {
        return () -> new Iterator<Type>(){
            private int index = 0;
            private final int max = types.length;

            @Override
            public boolean hasNext() {
                return this.index < this.max;
            }

            @Override
            public Type next() {
                if (this.index < this.max) {
                    return types[this.index++];
                }
                return null;
            }
        };
    }

    public static <Type> Iterable<Type> join(final Type head, final Iterable<Type> tail) {
        return () -> new Iterator<Type>(){
            private boolean headConsumed;
            private final Iterator tailIterator;
            {
                this.tailIterator = tail.iterator();
                this.headConsumed = false;
            }

            @Override
            public boolean hasNext() {
                return !this.headConsumed || this.tailIterator.hasNext();
            }

            @Override
            public Type next() {
                if (this.headConsumed) {
                    return this.tailIterator.next();
                }
                this.headConsumed = true;
                return head;
            }
        };
    }

    public static <T> Optional<T> last(Iterable<T> types) {
        Object result = null;
        if (types instanceof List) {
            List list = (List)types;
            if (list.size() >= 1) {
                result = list.get(list.size() - 1);
            }
        } else {
            for (T type : types) {
                result = type;
            }
        }
        return Optional.ofNullable(result);
    }

    public static <T> Optional<T> lastMatching(Iterable<T> types, Predicate<T> matcher) {
        return Iterables.last(Iterables.filter(types, matcher));
    }

    public static <Type> Optional<Type> nth(Iterable<Type> types, long index) {
        Object result;
        long counter = 0L;
        Iterator<Type> iterator = types.iterator();
        Object v0 = result = iterator.hasNext() ? iterator.next() : null;
        while (counter++ < index) {
            if (iterator.hasNext()) {
                result = iterator.next();
                continue;
            }
            result = null;
            break;
        }
        return Optional.ofNullable(result);
    }

    public static <Type> StreamIterable<Type> parallelStream(Iterable<Type> source) {
        return new StreamIterable<Type>(source, true);
    }

    public static <T> void print(Iterable<T> input, String name) {
        System.out.println(Iterables.toString(input, name));
    }

    public static <Type> long size(Iterable<Type> types) {
        if (types instanceof Collection) {
            return ((Collection)types).size();
        }
        return Iterables.count(types, type -> 1L);
    }

    public static <Type> StreamIterable<Type> stream(Iterable<Type> source) {
        return new StreamIterable<Type>(source);
    }

    public static <Type> Iterable<Type> tail(Iterable<Type> types) {
        Iterator iterator = types.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        return () -> iterator;
    }

    @SafeVarargs
    public static <Type> List<Type> toList(Type ... types) {
        return Iterables.asList(types);
    }

    public static <Type> String toString(Iterable<Type> input, String name) {
        return Iterables.toString(input, name, ", ");
    }

    public static <Type> String toString(Iterable<Type> input, String name, String separator) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(name);
        builder.append(": ");
        long index = 0L;
        for (Type type : input) {
            if (index > 0L) {
                builder.append(separator);
            }
            builder.append(type.toString());
            ++index;
        }
        builder.append("]");
        return builder.toString();
    }

    public static <TypeIn, TypeOut> Iterable<TypeOut> translate(Iterable<TypeIn> input, Function<TypeIn, TypeOut> converter) {
        return Iterables.filterTranslate(input, converter, item -> true);
    }

    public static <TypeIn, TypeOut> Iterable<TypeOut> translateFilter(Iterable<TypeIn> input, Function<TypeIn, TypeOut> converter, Predicate<TypeOut> matcher) {
        return Iterables.filter(Iterables.translate(input, converter), matcher);
    }

    public static <TypeIn, TypeOut> Iterable<TypeOut> translateMulti(Iterable<TypeIn> iterableIn, Function<TypeIn, Iterable<? extends TypeOut>> converter) {
        return new MultiIterable<TypeOut>(Iterables.translate(iterableIn, converter));
    }

    public static <Type> Iterable<Type> truncate(Iterable<Type> types, int startIndex, int indexFromEnd) {
        return new SubIterable<Type>(types, startIndex, indexFromEnd);
    }

    private Iterables() {
    }
}

