/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.collections;

import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;

public class FilteredIterable<Type, IdentifierType>
implements Iterable<Type> {
    private final Iterable<Type> source;
    private final Set<IdentifierType> filterSet;
    private final Function<Type, IdentifierType> identifier;

    public FilteredIterable(Iterable<Type> source, Set<IdentifierType> filterSet, Function<Type, IdentifierType> identifier) {
        this.filterSet = filterSet;
        this.source = source;
        this.identifier = identifier;
    }

    public boolean addToFilteredSet(Type type) {
        return this.filterSet.add(this.identifier.apply(type));
    }

    @Override
    public Iterator<Type> iterator() {
        return new Iterator<Type>(){
            private final Iterator<Type> sourceIterator;
            private Type next;
            private Type current;
            {
                this.sourceIterator = FilteredIterable.this.source.iterator();
                this.next = null;
                this.current = this.next();
            }

            @Override
            public boolean hasNext() {
                return this.next != null && !FilteredIterable.this.filterSet.contains(FilteredIterable.this.identifier.apply(this.next));
            }

            @Override
            public Type next() {
                this.current = this.next;
                this.next = null;
                while (this.sourceIterator.hasNext()) {
                    Object nextCandidate = this.sourceIterator.next();
                    if (FilteredIterable.this.filterSet.contains(FilteredIterable.this.identifier.apply(nextCandidate))) continue;
                    this.next = nextCandidate;
                    break;
                }
                return this.current;
            }
        };
    }
}

