/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.cli.operations;

import java.io.IOException;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.openstreetmap.atlas.utilities.cli.operations.AbstractHDFSOperation;
import org.openstreetmap.atlas.utilities.cli.operations.base.SSHOperationResults;

public class HDFSLSOperation
extends AbstractHDFSOperation {
    @Override
    public HDFSLSOperation asUser(String username) {
        super.asUser(username);
        return this;
    }

    public Stream<String> list(Path remotePath) throws InterruptedException, IOException {
        if (remotePath == null) {
            throw new IllegalArgumentException("remotePath can't be null");
        }
        this.prepareSSH().addArgs("-ls", this.preparePath(remotePath.toString()));
        SSHOperationResults results = this.handleResults(this.ssh().execute());
        return Stream.of(results.getOutput().split("\n")).filter(i -> i.indexOf(47) != -1).map(line -> {
            String[] pieces = line.split(" ");
            return pieces[pieces.length - 1];
        });
    }

    @Override
    public HDFSLSOperation onHost(String host) {
        super.onHost(host);
        return this;
    }

    @Override
    public HDFSLSOperation onPort(int portNumber) {
        super.onPort(portNumber);
        return this;
    }

    @Override
    public HDFSLSOperation withConfiguration(String configuration) {
        super.withConfiguration(configuration);
        return this;
    }
}

