/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.cli.operations;

import java.io.IOException;
import java.nio.file.Path;
import org.openstreetmap.atlas.utilities.cli.operations.AbstractHDFSOperation;
import org.openstreetmap.atlas.utilities.cli.operations.base.SSHOperationResults;

public class HDFSCopyOperation
extends AbstractHDFSOperation {
    @Override
    public HDFSCopyOperation asUser(String username) {
        super.asUser(username);
        return this;
    }

    public SSHOperationResults copy(Path source, Path destination) throws InterruptedException, IOException {
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination can't be null");
        }
        this.prepareSSH().addArgs("-cp", this.preparePath(source.toString()), this.preparePath(destination.toString()));
        return this.handleResults(this.ssh().execute());
    }

    @Override
    public HDFSCopyOperation onHost(String host) {
        super.onHost(host);
        return this;
    }

    @Override
    public HDFSCopyOperation onPort(int portNumber) {
        super.onPort(portNumber);
        return this;
    }

    @Override
    public HDFSCopyOperation withConfiguration(String configuration) {
        super.withConfiguration(configuration);
        return this;
    }
}

