/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.names;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.locale.IsoLanguage;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.names.AlternativeNameTag;
import org.openstreetmap.atlas.tags.names.HistoricallyKnownAsTag;
import org.openstreetmap.atlas.tags.names.HistoricallyReferencedAsTag;
import org.openstreetmap.atlas.tags.names.InternationallyKnownAsTag;
import org.openstreetmap.atlas.tags.names.InternationallyReferencedAsTag;
import org.openstreetmap.atlas.tags.names.LocallyKnownAsTag;
import org.openstreetmap.atlas.tags.names.LocallyReferencedAsTag;
import org.openstreetmap.atlas.tags.names.NameTag;
import org.openstreetmap.atlas.tags.names.NationallyKnownAsTag;
import org.openstreetmap.atlas.tags.names.NationallyReferencedAsTag;
import org.openstreetmap.atlas.tags.names.OfficialNameTag;
import org.openstreetmap.atlas.tags.names.ReferenceTag;
import org.openstreetmap.atlas.tags.names.RegionallyKnownAsTag;
import org.openstreetmap.atlas.tags.names.RegionallyReferencedAsTag;
import org.openstreetmap.atlas.tags.names.ShortNameTag;
import org.openstreetmap.atlas.utilities.collections.EnhancedCollectors;

public class NameFinder
implements Serializable {
    public static final ImmutableList<Class<?>> STANDARD_TAGS_NON_REFERENCE = ((ImmutableList.Builder)new ImmutableList.Builder().add(new Class[]{NameTag.class, InternationallyKnownAsTag.class, NationallyKnownAsTag.class, RegionallyKnownAsTag.class, LocallyKnownAsTag.class, HistoricallyKnownAsTag.class, AlternativeNameTag.class, ShortNameTag.class, OfficialNameTag.class})).build();
    public static final ImmutableList<Class<?>> STANDARD_TAGS_REFERENCE = ((ImmutableList.Builder)new ImmutableList.Builder().add(new Class[]{ReferenceTag.class, InternationallyReferencedAsTag.class, NationallyReferencedAsTag.class, RegionallyReferencedAsTag.class, LocallyReferencedAsTag.class, HistoricallyReferencedAsTag.class})).build();
    public static final ImmutableList<Class<?>> STANDARD_TAGS = ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(STANDARD_TAGS_NON_REFERENCE)).addAll(STANDARD_TAGS_REFERENCE)).build();
    public static final ImmutableList<String> STANDARD_TAG_KEYS = STANDARD_TAGS.stream().map(Validators::findTagNameIn).collect(EnhancedCollectors.toImmutableList());
    private static final long serialVersionUID = -7268140468931884651L;
    private transient IsoLanguage language = null;
    private final LinkedHashSet<Class<?>> priorityOrderOfTagNames;
    private Taggable.TagSearchOption searchOption = Taggable.TagSearchOption.DEFAULT;

    public static NameFinder createStandardSet(IsoLanguage language) {
        return new NameFinder().withTags(STANDARD_TAGS).inLanguage(language);
    }

    private static List<Taggable> children(AtlasEntity entity) {
        ArrayList<Taggable> taggables = new ArrayList<Taggable>();
        taggables.add(entity);
        ArrayList<Relation> relations = new ArrayList<Relation>(entity.relations());
        relations.sort(Relation.RELATION_ID_COMPARATOR);
        Iterables.addAll(taggables, relations);
        return taggables;
    }

    public NameFinder() {
        this.priorityOrderOfTagNames = new LinkedHashSet();
    }

    public Map<Class<?>, String> all(Taggable taggable) {
        HashMap returnValue = new HashMap();
        for (Class clazz : this.priorityOrderOfTagNames) {
            taggable.getTag(clazz, Optional.ofNullable(this.language), this.searchOption).ifPresent(tagValue -> returnValue.put(tagClass, (String)tagValue));
        }
        return returnValue;
    }

    public Optional<String> best(AtlasEntity entity) {
        return NameFinder.children(entity).stream().map(this::best).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Optional<String> best(Taggable taggable) {
        return this.priorityOrderOfTagNames.stream().map(tagClass -> taggable.getTag((Class<?>)tagClass, Optional.ofNullable(this.language), this.searchOption)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public NameFinder forceLocalized() {
        this.searchOption = Taggable.TagSearchOption.FORCE_ALL_LOCALIZED_ONLY;
        return this;
    }

    public ImmutableCollection<Class<?>> getTagNames() {
        return ((ImmutableList.Builder)ImmutableList.builder().addAll(this.priorityOrderOfTagNames)).build();
    }

    public NameFinder inLanguage(IsoLanguage language) {
        this.language = language;
        return this;
    }

    public NameFinder localizedOnly() {
        this.searchOption = Taggable.TagSearchOption.LOCALIZED_ONLY;
        return this;
    }

    public NameFinder withTags(Class<?> ... tagClasses) {
        for (Class<?> tagClass : tagClasses) {
            this.priorityOrderOfTagNames.add(tagClass);
        }
        return this;
    }

    public NameFinder withTags(Iterable<Class<?>> tagClasses) {
        for (Class<?> tagClass : tagClasses) {
            this.priorityOrderOfTagNames.add(tagClass);
        }
        return this;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        String iso2 = (String)stream.readObject();
        if (iso2 != null) {
            this.language = IsoLanguage.forLanguageCode(iso2).orElse(null);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        String iso2 = this.language == null ? null : this.language.getLanguageCode();
        stream.writeObject(iso2);
    }
}

