/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.annotations.validation;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.validation.DoubleValidator;
import org.openstreetmap.atlas.tags.annotations.validation.TagValidator;

public class SpeedValidator
implements TagValidator {
    private static final DoubleValidator DOUBLE_VALIDATOR;
    private static final JsonObject IMPLICIT_SPEED_MAP;

    @Override
    public boolean isValid(String value) {
        if (value.endsWith("mph")) {
            return DOUBLE_VALIDATOR.isValid(value.substring(0, value.length() - "mph".length()).trim());
        }
        if (value.endsWith("knots")) {
            return DOUBLE_VALIDATOR.isValid(value.substring(0, value.length() - "knots".length()).trim());
        }
        if (value.endsWith("kph")) {
            return DOUBLE_VALIDATOR.isValid(value.substring(0, value.length() - "kph".length()).trim());
        }
        if ("none".equals(value)) {
            return true;
        }
        if (IMPLICIT_SPEED_MAP.has(value.toLowerCase())) {
            return true;
        }
        return DOUBLE_VALIDATOR.isValid(value);
    }

    static {
        IMPLICIT_SPEED_MAP = (JsonObject)new Gson().fromJson(new JsonReader(new InputStreamReader(Tag.class.getResourceAsStream("implicit-speed-values.json"))), (Type)((Object)JsonObject.class));
        DOUBLE_VALIDATOR = new DoubleValidator();
        DOUBLE_VALIDATOR.setMinimum(0L);
    }
}

