/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.annotations.extraction;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.Optional;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.validation.SpeedValidator;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.scalars.Speed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpeedExtractor {
    private static final SpeedValidator VALIDATOR = new SpeedValidator();
    private static final String SINGLE_SPACE = " ";
    private static final Logger logger = LoggerFactory.getLogger(SpeedExtractor.class);
    private static final JsonObject IMPLICIT_SPEED_MAP = (JsonObject)new Gson().fromJson(new JsonReader(new InputStreamReader(Tag.class.getResourceAsStream("implicit-speed-values.json"))), (Type)((Object)JsonObject.class));

    public static Optional<Speed> validateAndExtract(String value) {
        if (VALIDATOR.isValid(value)) {
            try {
                String valueOrImplicit;
                String string = valueOrImplicit = IMPLICIT_SPEED_MAP.has(value.toLowerCase()) ? IMPLICIT_SPEED_MAP.get(value.toLowerCase()).getAsString() : value;
                if (valueOrImplicit.endsWith("mph")) {
                    return Optional.of(Speed.milesPerHour(Double.valueOf(StringList.split(valueOrImplicit, SINGLE_SPACE).iterator().next())));
                }
                if (valueOrImplicit.endsWith("knots")) {
                    return Optional.of(Speed.knots(Double.valueOf(StringList.split(valueOrImplicit, SINGLE_SPACE).iterator().next())));
                }
                if (valueOrImplicit.endsWith("kph")) {
                    return Optional.of(Speed.kilometersPerHour(Double.valueOf(StringList.split(valueOrImplicit, SINGLE_SPACE).iterator().next())));
                }
                if ("none".equals(valueOrImplicit)) {
                    return Optional.empty();
                }
                return Optional.of(Speed.kilometersPerHour(Double.valueOf(valueOrImplicit)));
            }
            catch (NumberFormatException e) {
                logger.warn("Unable to read speed from {}", (Object)value);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private SpeedExtractor() {
    }
}

