/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.writers;

import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.resource.WritableResource;

public class JsonWriter
implements Closeable {
    private final BufferedWriter writer;

    public JsonWriter(WritableResource resource) {
        this.writer = new BufferedWriter(new OutputStreamWriter(resource.write(), StandardCharsets.UTF_8));
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new CoreException("Cannot close JsonWriter", e);
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            this.close();
            throw new CoreException("Cannot flush JsonWriter", e);
        }
    }

    public void write(JsonObject object) {
        String value = object.toString();
        try {
            this.writer.write(value);
        }
        catch (IOException e) {
            this.close();
            throw new CoreException("Could not write String to JsonWriter", e);
        }
    }

    public void writeLine(JsonObject object) {
        String value = object.toString();
        this.writeLine(value);
    }

    private void writeLine(String stringValue) {
        try {
            this.writer.write(stringValue);
            this.writer.newLine();
        }
        catch (IOException e) {
            this.close();
            throw new CoreException("Could not write String to JsonWriter", e);
        }
    }
}

