/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.resource.zip;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.streaming.resource.zip.ZipResource;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public class ZipWritableResource
extends ZipResource {
    private static final int ZIP_MAXIMUM_COMPRESSION_LEVEL = 9;
    private boolean compression = true;

    public ZipWritableResource(WritableResource source) {
        super(source);
    }

    public void setWriteCompression(boolean compression) {
        this.compression = compression;
    }

    public ZipWritableResource withWriteCompression(boolean compression) {
        this.setWriteCompression(compression);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeAndClose(Iterable<? extends Resource> entries) {
        try (ZipOutputStream output = new ZipOutputStream(new BufferedOutputStream(this.getWritableSource().write()));){
            output.setLevel(this.compression ? 9 : 0);
            int counter = 0;
            for (Resource resource : entries) {
                String name = resource.getName();
                if (name == null) {
                    name = "Entry " + counter;
                }
                ZipEntry entry = new ZipEntry(resource.getName());
                output.putNextEntry(entry);
                try {
                    InputStream input = resource.read();
                    try {
                        IOUtils.copy(input, output);
                        ++counter;
                    }
                    finally {
                        if (input == null) continue;
                        input.close();
                    }
                }
                catch (Exception e) {
                    throw new CoreException("Unable to read resource {}", resource, e);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new CoreException("Unable to write next ZipEntry!", e);
        }
    }

    public void writeAndClose(Resource ... entries) {
        this.writeAndClose(Iterables.asList(entries));
    }

    protected WritableResource getWritableSource() {
        return (WritableResource)this.getSource();
    }
}

