/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.resource;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.NotifyingIOUtils;
import org.openstreetmap.atlas.streaming.Streams;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.StringList;

public interface Resource {
    public static final int BYTE_MASK = 255;

    default public String all() {
        return new StringList(this.lines()).join("\n");
    }

    default public void copyTo(WritableResource output) {
        try (InputStream inputStream = this.read();
             OutputStream outputStream = output.write();){
            IOUtils.copy(inputStream, outputStream);
        }
        catch (Exception e) {
            throw new CoreException("Unable to copy {} to {}.", this, output, e);
        }
    }

    default public void copyTo(WritableResource output, NotifyingIOUtils.IOProgressListener listener) {
        try (InputStream inputStream = this.read();
             OutputStream outputStream = output.write();){
            NotifyingIOUtils.copy(inputStream, outputStream, listener);
        }
        catch (Exception e) {
            throw new CoreException("Unable to copy {} to {}.", this, output, e);
        }
    }

    default public String firstLine() {
        String string;
        block8: {
            BufferedReader reader = this.reader();
            try {
                string = reader.readLine();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CoreException("Unable to read first line of {}", this, e);
                }
            }
            reader.close();
        }
        return string;
    }

    default public String getName() {
        return null;
    }

    default public boolean isGzipped() {
        return FileSuffix.GZIP.matches(this);
    }

    public long length();

    default public Iterable<String> lines() {
        final BufferedReader reader = this.reader();
        return () -> {
            try {
                return new Iterator<String>(){
                    private String line;
                    {
                        this.line = reader.readLine();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.line != null;
                    }

                    @Override
                    public String next() {
                        String result = this.line;
                        try {
                            this.line = reader.readLine();
                        }
                        catch (IOException e) {
                            Streams.close(reader);
                            throw new CoreException("Could not read resource line", e);
                        }
                        if (this.line == null) {
                            Streams.close(reader);
                        }
                        return result;
                    }
                };
            }
            catch (IOException e) {
                Streams.close(reader);
                throw new CoreException("Could not read resource line", e);
            }
        };
    }

    default public StringList linesList() {
        return new StringList(this.lines());
    }

    public InputStream read();

    default public String readAndClose() {
        StringList builder = new StringList();
        this.lines().forEach(builder::add);
        return builder.join(System.lineSeparator());
    }

    default public byte[] readBytesAndClose() {
        ArrayList<Byte> byteContents = new ArrayList<Byte>();
        try (BufferedInputStream input = new BufferedInputStream(this.read());){
            int kyte;
            while ((kyte = ((InputStream)input).read()) >= 0) {
                byteContents.add((byte)(kyte & 0xFF));
            }
        }
        catch (IOException e) {
            throw new CoreException("Unable to read the bytes from {}.", this, e);
        }
        byte[] contents = new byte[byteContents.size()];
        for (int index = 0; index < byteContents.size(); ++index) {
            contents[index] = (Byte)byteContents.get(index);
        }
        return contents;
    }

    default public BufferedReader reader() {
        return new BufferedReader(new InputStreamReader(this.read(), StandardCharsets.UTF_8));
    }
}

