/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.resource;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.Properties;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.Streams;
import org.openstreetmap.atlas.streaming.resource.AbstractResource;

public class ClassResource
extends AbstractResource {
    private final String resource;

    public ClassResource(String resource) {
        this.resource = resource;
    }

    public <T> T getJSONResourceObject(Gson gson, Type classType) {
        InputStream input = null;
        try {
            input = this.onRead();
            JsonReader reader = new JsonReader(new InputStreamReader(this.onRead()));
            Object t = gson.fromJson(reader, classType);
            return t;
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new CoreException("Failed to load json file from resource file {}", this.resource, e);
        }
        finally {
            Streams.close(input);
        }
    }

    public <T> T getJSONResourceObject(Type classType) {
        return this.getJSONResourceObject(new Gson(), classType);
    }

    public Properties getResourceAsPropertyFile() {
        InputStream input = null;
        try {
            input = this.onRead();
            Properties props = new Properties();
            props.load(input);
            Properties properties = props;
            return properties;
        }
        catch (IOException ioe) {
            throw new CoreException("Failed to load properties from resource file {}", this.resource, ioe);
        }
        finally {
            Streams.close(input);
        }
    }

    @Override
    protected InputStream onRead() {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        if (classloader == null) {
            throw new CoreException("Context Class loader could not be initialized.");
        }
        InputStream input = classloader.getResourceAsStream(this.resource);
        if (input == null) {
            throw new CoreException("Resource, {}, not found.", this.resource);
        }
        return input;
    }
}

