/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.readers.json.converters;

import com.google.gson.JsonArray;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.streaming.readers.json.converters.PointCoordinateConverter;
import org.openstreetmap.atlas.utilities.conversion.Converter;

public class PolygonCoordinateConverter
implements Converter<Iterable<Location>, JsonArray> {
    private final PointCoordinateConverter coordinateConverter = new PointCoordinateConverter();

    @Override
    public JsonArray convert(Iterable<Location> object) {
        JsonArray result = new JsonArray();
        JsonArray inner = new JsonArray();
        object.forEach(location -> inner.add(this.coordinateConverter.convert((Location)location)));
        result.add(inner);
        return result;
    }

    public Converter<JsonArray, List<Location>> revert() {
        return jsonArray -> {
            ArrayList result = new ArrayList();
            jsonArray.forEach(jsonElement -> {
                JsonArray array = (JsonArray)jsonElement;
                array.forEach(element -> {
                    JsonArray array2 = (JsonArray)element;
                    result.add(this.coordinateConverter.revert().convert(array2));
                });
            });
            if (result.isEmpty() || !((Location)result.get(0)).equals(result.get(result.size() - 1))) {
                throw new CoreException("Invalidly formatted Geojson Polygon");
            }
            result.remove(result.size() - 1);
            return result;
        };
    }
}

