/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming;

import java.io.IOException;
import java.io.OutputStream;
import org.openstreetmap.atlas.exception.CoreException;

public class CounterOutputStream
extends OutputStream {
    private long count = 0L;
    private boolean closed = false;

    @Override
    public void close() {
        this.closed = true;
    }

    public long getCount() {
        if (!this.closed) {
            throw new CoreException("Cannot get the counts when the stream has not been closed.");
        }
        return this.count;
    }

    @Override
    public void write(byte[] bite, int offset, int length) throws IOException {
        this.count += (long)(length - offset);
    }

    @Override
    public void write(int value) throws IOException {
        ++this.count;
    }
}

