/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.sharding.converters;

import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class SlippyTileConverter
implements TwoWayConverter<SlippyTile, String> {
    private static final String SEPARATOR = "-";
    private static final int TILE_DIMENSIONS = 3;

    @Override
    public SlippyTile backwardConvert(String slippyTileParameters) {
        StringList splits = StringList.split(slippyTileParameters, SEPARATOR);
        if (splits.size() != 3) {
            throw new CoreException("Wrong format of input string {}", slippyTileParameters);
        }
        int zoom = Integer.valueOf(splits.get(0));
        int xAxis = Integer.valueOf(splits.get(1));
        int yAxis = Integer.valueOf(splits.get(2));
        return new SlippyTile(xAxis, yAxis, zoom);
    }

    @Override
    public String convert(SlippyTile slippyTile) {
        return slippyTile.getZoom() + SEPARATOR + slippyTile.getX() + SEPARATOR + slippyTile.getY();
    }
}

