/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.sharding;

import java.io.Serializable;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.sharding.DynamicTileSharding;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.SlippyTileSharding;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.collections.StringList;

public interface Sharding
extends Serializable {
    public static final int SHARDING_STRING_SPLIT = 2;
    public static final int SLIPPY_ZOOM_MAXIMUM = 18;

    public static Sharding forString(String sharding) {
        StringList split = StringList.split(sharding, "@");
        if (split.size() != 2) {
            throw new CoreException("Invalid sharding string: {} (correct e.g. dynamic@/path/to/tree)", sharding);
        }
        if ("slippy".equals(split.get(0))) {
            int zoom = Integer.valueOf(split.get(1));
            if (zoom > 18) {
                throw new CoreException("Slippy Sharding zoom too high : {}, max is {}", zoom, 18);
            }
            return new SlippyTileSharding(zoom);
        }
        if ("dynamic".equals(split.get(0))) {
            String definition = split.get(1);
            return new DynamicTileSharding(new File(definition));
        }
        throw new CoreException("Sharding type {} is not recognized.", split.get(0));
    }

    public Iterable<? extends Shard> neighbors(Shard var1);

    default public Iterable<? extends Shard> shards() {
        return this.shards(Rectangle.MAXIMUM);
    }

    public Iterable<? extends Shard> shards(GeometricSurface var1);

    public Iterable<? extends Shard> shardsCovering(Location var1);

    public Iterable<? extends Shard> shardsIntersecting(PolyLine var1);
}

