/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.index;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.locationtech.jts.index.strtree.STRtree;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.index.JtsSpatialIndex;

public class RTree<T>
implements JtsSpatialIndex<T> {
    private static final long serialVersionUID = -3672714932238885163L;
    private final STRtree tree;
    private Rectangle bound;

    public static <K extends Located> RTree<K> forLocated(Iterable<K> locatedIterable) {
        RTree toReturn = new RTree();
        locatedIterable.forEach(located -> toReturn.add(located.bounds(), located));
        return toReturn;
    }

    public static <K> RTree<K> forCollection(Iterable<K> iterable, Function<K, Rectangle> transform) {
        RTree toReturn = new RTree();
        iterable.forEach(item -> toReturn.add((Rectangle)transform.apply(item), item));
        return toReturn;
    }

    public RTree() {
        this.tree = new STRtree();
    }

    public RTree(int nodeCapacity) {
        this.tree = new STRtree(nodeCapacity);
    }

    @Override
    public void add(Rectangle bound, T item) {
        this.tree.insert(bound.asEnvelope(), item);
        this.bound = this.bound != null ? this.bound.combine(bound) : bound;
    }

    @Override
    public Rectangle bounds() {
        return this.bound;
    }

    public void build() {
        this.tree.build();
    }

    public int depth() {
        return this.tree.depth();
    }

    @Override
    public List<T> get(Rectangle bound) {
        return this.tree.query(bound.asEnvelope());
    }

    @Override
    public List<T> get(Rectangle bound, Predicate<T> predicate) {
        return this.get(bound).stream().filter(predicate).collect(Collectors.toList());
    }

    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    public List<T> itemsTree() {
        return this.tree.itemsTree();
    }

    @Override
    public boolean remove(Rectangle bound, T item) {
        return this.tree.remove(bound.asEnvelope(), item);
    }

    @Override
    public int size() {
        return this.tree.size();
    }
}

