/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.geojson;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.geojson.GeoJsonFeature;
import org.openstreetmap.atlas.geography.geojson.GeoJsonFeatureCollection;
import org.openstreetmap.atlas.geography.geojson.GeoJsonGeometry;
import org.openstreetmap.atlas.geography.geojson.GeoJsonType;
import org.openstreetmap.atlas.geography.geojson.GeojsonGeometryCollection;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeoJsonUtils {
    private static final Logger logger = LoggerFactory.getLogger(GeoJsonUtils.class);
    public static final String IDENTIFIER = "identifier";
    public static final String OSM_IDENTIFIER = "osmIdentifier";
    public static final String ITEM_TYPE = "itemType";

    private GeoJsonUtils() {
    }

    public static JsonObject feature(GeoJsonFeature geoJsonFeature) {
        if (!geoJsonFeature.getGeoJsonType().equals((Object)GeoJsonType.FEATURE)) {
            logger.warn("Constructing GeoJson Feature Json for something with incorrect Geojson type: object {} with type {}", (Object)geoJsonFeature, (Object)geoJsonFeature.getGeoJsonType());
        }
        return GeoJsonUtils.feature(geoJsonFeature.asGeoJsonGeometry(), geoJsonFeature.getGeoJsonProperties());
    }

    public static JsonObject feature(JsonObject geometry, JsonObject properties) {
        JsonObject feature = new JsonObject();
        feature.addProperty("type", GeoJsonType.FEATURE.getTypeString());
        feature.add("geometry", geometry);
        feature.add("properties", properties);
        return feature;
    }

    public static JsonObject featureCollection(GeoJsonFeatureCollection<? extends GeoJsonFeature> featureCollection) {
        if (!featureCollection.getGeoJsonType().equals((Object)GeoJsonType.FEATURE_COLLECTION)) {
            logger.warn("Constructing GeoJson Feature Json for something with incorrect Geojson type: object {} with type {}", featureCollection, (Object)featureCollection.getGeoJsonType());
        }
        return GeoJsonUtils.featureCollection(featureCollection.getGeoJsonObjects(), featureCollection.getGeoJsonProperties());
    }

    public static JsonObject featureCollection(Iterable<? extends GeoJsonFeature> featureObjects, JsonObject properties) {
        JsonObject featureCollection = new JsonObject();
        featureCollection.addProperty("type", GeoJsonType.FEATURE_COLLECTION.getTypeString());
        JsonArray features = new JsonArray();
        Iterables.stream(featureObjects).map(GeoJsonUtils::feature).forEach(features::add);
        featureCollection.add("features", features);
        featureCollection.add("properties", properties);
        return featureCollection;
    }

    public static JsonObject boundsToPolygonGeometry(Rectangle bounds) {
        JsonArray outerRing = new JsonArray();
        Iterable<Location> locations = bounds.closedLoop();
        for (Location location : locations) {
            outerRing.add(GeoJsonUtils.coordinate(location));
        }
        JsonArray coordinates = new JsonArray();
        coordinates.add(outerRing);
        return GeoJsonUtils.geometry(GeoJsonType.POLYGON, coordinates);
    }

    public static JsonObject geometry(GeojsonGeometryCollection<? extends GeoJsonGeometry> geojsonGeometryCollection) {
        if (!geojsonGeometryCollection.getGeoJsonType().equals((Object)GeoJsonType.GEOMETRY_COLLECTION)) {
            logger.warn("Constructing GeoJson Geometry Collection Json for something with incorrect Geojson type: object {} with type {}", geojsonGeometryCollection, (Object)geojsonGeometryCollection.getGeoJsonType());
        }
        JsonObject geometry = new JsonObject();
        JsonArray geometries = new JsonArray();
        geojsonGeometryCollection.getGeoJsonObjects().forEach(geoJsonGeometry -> geometries.add(geoJsonGeometry.asGeoJsonGeometry()));
        geometry.addProperty("type", GeoJsonType.GEOMETRY_COLLECTION.getTypeString());
        geometry.add("geometries", geometries);
        return geometry;
    }

    public static JsonObject geometry(GeoJsonType type, JsonArray coordinates) {
        Validate.isTrue(GeoJsonType.isGeometryType(type), "Type is not geometry type. ", new Object[0]);
        Validate.isTrue(!type.equals((Object)GeoJsonType.GEOMETRY_COLLECTION), "Geometry Collection cannot be represented by coordinate array", new Object[0]);
        JsonObject geometry = new JsonObject();
        geometry.addProperty("type", type.getTypeString());
        geometry.add("coordinates", coordinates);
        return geometry;
    }

    public static JsonArray multiPolygonToCoordinates(MultiPolygon multiPolygon) {
        JsonArray polygons = new JsonArray();
        multiPolygon.getOuterToInners().forEach((outer, inners) -> polygons.add(GeoJsonUtils.polygonToCoordinates(outer, Optional.of(inners))));
        return polygons;
    }

    public static JsonArray polygonToCoordinates(Polygon polygon) {
        return GeoJsonUtils.polygonToCoordinates(polygon, Optional.empty());
    }

    private static JsonArray polygonToCoordinates(Polygon outer, Optional<Iterable<Polygon>> inners) {
        JsonArray polygon = new JsonArray();
        polygon.add(GeoJsonUtils.locationsToCoordinates(outer.closedLoop()));
        inners.ifPresent(innerPolygons -> innerPolygons.forEach(innerPolygon -> polygon.add(GeoJsonUtils.locationsToCoordinates(innerPolygon.closedLoop()))));
        return polygon;
    }

    public static JsonArray locationsToCoordinates(Iterable<Location> locations) {
        JsonArray coordinates = new JsonArray();
        for (Location point : locations) {
            coordinates.add(GeoJsonUtils.coordinate(point));
        }
        return coordinates;
    }

    public static JsonArray coordinate(Location location) {
        return GeoJsonUtils.coordinate(location.getLongitude().asDegrees(), location.getLatitude().asDegrees());
    }

    public static JsonArray coordinate(double longitude, double latitude) {
        JsonArray coordinate = new JsonArray();
        coordinate.add(new JsonPrimitive(longitude));
        coordinate.add(new JsonPrimitive(latitude));
        return coordinate;
    }
}

