/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.geojson;

import com.google.gson.JsonObject;
import java.util.EnumSet;
import org.openstreetmap.atlas.exception.CoreException;

public enum GeoJsonType {
    FEATURE("Feature"),
    FEATURE_COLLECTION("FeatureCollection"),
    POINT("Point"),
    MULTI_POINT("MultiPoint"),
    LINESTRING("LineString"),
    MULTI_LINESTRING("MultiLineString"),
    POLYGON("Polygon"),
    MULTI_POLYGON("MultiPolygon"),
    GEOMETRY_COLLECTION("GeometryCollection");

    private static final EnumSet GEOMETRY_TYPES;
    private static final EnumSet FEATURE_TYPES;
    private final String typeString;

    public static GeoJsonType forString(String type) {
        for (GeoJsonType value : GeoJsonType.values()) {
            if (!value.getTypeString().equals(type)) continue;
            return value;
        }
        throw new CoreException("Invalid geoJson type: {}", type);
    }

    public static GeoJsonType forJson(JsonObject object) {
        String typeString;
        try {
            typeString = object.get("type").getAsString();
        }
        catch (Exception exception) {
            throw new CoreException("Invalid geoJson type: {}", object.get("type"));
        }
        return GeoJsonType.forString(typeString);
    }

    private GeoJsonType(String typeString) {
        this.typeString = typeString;
    }

    public String toString() {
        return this.typeString;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public static boolean isGeometryType(GeoJsonType type) {
        return GEOMETRY_TYPES.contains((Object)type);
    }

    public static boolean isFeatureType(GeoJsonType type) {
        return FEATURE_TYPES.contains((Object)type);
    }

    static {
        GEOMETRY_TYPES = EnumSet.of(POINT, new GeoJsonType[]{MULTI_POINT, LINESTRING, MULTI_LINESTRING, POLYGON, MULTI_POLYGON, GEOMETRY_COLLECTION});
        FEATURE_TYPES = EnumSet.of(FEATURE, FEATURE_COLLECTION);
    }
}

