/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.geojson;

import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.geography.geojson.GeoJsonObject;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.streaming.writers.JsonWriter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;

public final class GeoJsonSaver {
    public static void save(Iterable<? extends Iterable<Location>> geometries, WritableResource destination) {
        GeoJsonObject object = new GeoJsonBuilder().create(Iterables.translate(geometries, polyLine -> new GeoJsonBuilder.LocationIterableProperties((Iterable<Location>)polyLine, Maps.hashMap(new String[0]))));
        GeoJsonSaver.save(object, destination);
    }

    public static void saveMultipolygon(Iterable<MultiPolygon> geometries, WritableResource destination) {
        Iterable outers = Iterables.translateMulti(geometries, multiPolygon -> multiPolygon.outers());
        Iterable inners = Iterables.translateMulti(geometries, multiPolygon -> multiPolygon.inners());
        MultiIterable multi = new MultiIterable(outers, inners);
        GeoJsonSaver.save(multi, destination);
    }

    private static void save(GeoJsonObject object, WritableResource destination) {
        JsonWriter writer = new JsonWriter(destination);
        writer.write(object.jsonObject());
        writer.close();
    }

    private GeoJsonSaver() {
    }
}

