/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.geojson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.Streams;
import org.openstreetmap.atlas.streaming.resource.WritableResource;

public class GeoJsonObject {
    private JsonObject jsonObject;

    protected GeoJsonObject(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.jsonObject.get("properties") != null) {
            JsonObject propertiesObject = (JsonObject)this.jsonObject.get("properties");
            for (Map.Entry<String, JsonElement> entry : propertiesObject.entrySet()) {
                result.put(entry.getKey(), entry.getValue().toString());
            }
        }
        return result;
    }

    public JsonObject jsonObject() {
        return this.jsonObject;
    }

    public void makeFeatureCollection() {
        if (!"FeatureCollection".equals(this.jsonObject.get("type").getAsString())) {
            JsonObject result = new JsonObject();
            result.addProperty("type", "FeatureCollection");
            JsonArray features = new JsonArray();
            features.add(this.jsonObject);
            result.add("features", features);
            this.jsonObject = result;
        }
    }

    public void save(WritableResource output) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output.write(), StandardCharsets.UTF_8));
        try {
            writer.write(this.jsonObject.toString());
            Streams.close(writer);
        }
        catch (Exception e) {
            Streams.close(writer);
            throw new CoreException("Could not save geojson object", e);
        }
    }

    public String toPrettyString() {
        return new GsonBuilder().setPrettyPrinting().create().toJson(this.jsonObject);
    }

    public String toString() {
        return this.jsonObject.toString();
    }

    public GeoJsonObject withNewProperties(Map<String, ? extends Object> properties) {
        JsonObject propertiesObject;
        if (this.jsonObject.get("properties") != null) {
            propertiesObject = (JsonObject)this.jsonObject.get("properties");
            this.jsonObject.remove("properties");
        } else {
            propertiesObject = new JsonObject();
        }
        Gson gson = new Gson();
        properties.forEach((key, value) -> propertiesObject.add((String)key, gson.toJsonTree(value)));
        this.jsonObject.add("properties", propertiesObject);
        return this;
    }

    public GeoJsonObject withNewProperty(String key, Object value) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(key, value);
        return this.withNewProperties(properties);
    }
}

