/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters.jts;

import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.converters.jts.JtsCoordinateArrayConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPrecisionManager;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class JtsPolyLineConverter
implements TwoWayConverter<PolyLine, LineString> {
    private static final JtsCoordinateArrayConverter COORDINATE_ARRAY_CONVERTER = new JtsCoordinateArrayConverter();
    private static final GeometryFactory FACTORY = JtsPrecisionManager.getGeometryFactory();

    @Override
    public PolyLine backwardConvert(LineString lineString) {
        return new PolyLine(COORDINATE_ARRAY_CONVERTER.backwardConvert(lineString.getCoordinateSequence()));
    }

    @Override
    public LineString convert(PolyLine polyLine) {
        return new LineString(COORDINATE_ARRAY_CONVERTER.convert(polyLine), FACTORY);
    }
}

