/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters.jts;

import java.util.Iterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Polygon;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public final class GeometryStreamer {
    public static Iterable<Geometry> stream(final GeometryCollection collection) {
        final int size = collection.getNumGeometries();
        return () -> new Iterator<Geometry>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < size;
            }

            @Override
            public Geometry next() {
                return collection.getGeometryN(this.index++);
            }
        };
    }

    public static Iterable<Polygon> streamPolygons(GeometryCollection collection) {
        return Iterables.translate(GeometryStreamer.stream(collection), geometry -> (Polygon)geometry);
    }

    private GeometryStreamer() {
    }
}

