/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonConverter;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class WktPolygonConverter
implements TwoWayConverter<Polygon, String> {
    @Override
    public Polygon backwardConvert(String wkt) {
        org.locationtech.jts.geom.Polygon geometry = null;
        WKTReader myReader = new WKTReader();
        try {
            geometry = (org.locationtech.jts.geom.Polygon)myReader.read(wkt);
        }
        catch (ClassCastException | ParseException e) {
            throw new CoreException("Cannot parse wkt : {}", wkt);
        }
        return new JtsPolygonConverter().backwardConvert(geometry);
    }

    @Override
    public String convert(Polygon polygon) {
        org.locationtech.jts.geom.Polygon geometry = new JtsPolygonConverter().convert(polygon);
        return new WKTWriter().write(geometry);
    }
}

