/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.converters.jts.JtsMultiPolygonToMultiPolygonConverter;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class WktMultiPolygonConverter
implements TwoWayConverter<MultiPolygon, String> {
    @Override
    public MultiPolygon backwardConvert(String wkt) {
        org.locationtech.jts.geom.MultiPolygon geometry = null;
        WKTReader myReader = new WKTReader();
        try {
            geometry = (org.locationtech.jts.geom.MultiPolygon)myReader.read(wkt);
        }
        catch (ClassCastException | ParseException e) {
            throw new CoreException("Cannot parse wkt : {}", wkt);
        }
        return new JtsMultiPolygonToMultiPolygonConverter().convert(geometry);
    }

    @Override
    public String convert(MultiPolygon multiPolygon) {
        org.locationtech.jts.geom.MultiPolygon geometry = new JtsMultiPolygonToMultiPolygonConverter().backwardConvert(multiPolygon);
        return new WKTWriter().write(geometry);
    }
}

