/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.locationtech.jts.io.WKBReader;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.converters.MultiPolygonStringConverter;
import org.openstreetmap.atlas.geography.converters.PolygonStringConverter;
import org.openstreetmap.atlas.geography.converters.WkbMultiPolygonConverter;
import org.openstreetmap.atlas.geography.converters.WkbPolygonConverter;
import org.openstreetmap.atlas.geography.converters.WktMultiPolygonConverter;
import org.openstreetmap.atlas.geography.converters.WktPolygonConverter;
import org.openstreetmap.atlas.streaming.readers.GeoJsonReader;
import org.openstreetmap.atlas.streaming.readers.json.serializers.PropertiesLocated;
import org.openstreetmap.atlas.streaming.resource.StringResource;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PolygonStringFormat {
    ATLAS("atlas"),
    GEOJSON("geojson"),
    WKT("wkt"),
    WKB("wkb"),
    UNSUPPORTED("UNSUPPORTED");

    private static final Logger logger;
    private String format;

    public static PolygonStringFormat getEnumForFormat(String format) {
        for (PolygonStringFormat polygonStringFormat : PolygonStringFormat.values()) {
            if (!polygonStringFormat.getFormat().equalsIgnoreCase(format)) continue;
            return polygonStringFormat;
        }
        return UNSUPPORTED;
    }

    private PolygonStringFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public StringConverter<Optional<List<MultiPolygon>>> getMultiPolygonConverter() {
        switch (this) {
            case ATLAS: {
                return string -> Optional.of(Collections.singletonList(new MultiPolygonStringConverter().convert((String)string)));
            }
            case GEOJSON: {
                return string -> {
                    ArrayList<MultiPolygon> multiPolygons = new ArrayList<MultiPolygon>();
                    GeoJsonReader reader = new GeoJsonReader(new StringResource((String)string));
                    while (reader.hasNext()) {
                        PropertiesLocated propertiesLocated = reader.next();
                        if (propertiesLocated.getItem() instanceof MultiPolygon) {
                            multiPolygons.add((MultiPolygon)propertiesLocated.getItem());
                            continue;
                        }
                        logger.warn("MultiPolygon Filter does not support item {}", (Object)propertiesLocated.toString());
                    }
                    return Optional.of(multiPolygons).filter(list -> !list.isEmpty());
                };
            }
            case WKB: {
                return string -> Optional.of(Collections.singletonList(new WkbMultiPolygonConverter().backwardConvert(WKBReader.hexToBytes(string))));
            }
            case WKT: {
                return string -> Optional.of(Collections.singletonList(new WktMultiPolygonConverter().backwardConvert((String)string)));
            }
        }
        logger.warn("No converter set up for {} format. Supported formats are {}", (Object)this.format, (Object)Arrays.copyOf(PolygonStringFormat.values(), PolygonStringFormat.values().length - 1));
        return string -> Optional.empty();
    }

    public StringConverter<Optional<List<Polygon>>> getPolygonConverter() {
        switch (this) {
            case ATLAS: {
                return string -> Optional.of(Collections.singletonList(new PolygonStringConverter().convert((String)string)));
            }
            case GEOJSON: {
                return string -> {
                    ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                    GeoJsonReader reader = new GeoJsonReader(new StringResource((String)string));
                    while (reader.hasNext()) {
                        PropertiesLocated propertiesLocated = reader.next();
                        if (propertiesLocated.getItem() instanceof Polygon) {
                            polygons.add((Polygon)propertiesLocated.getItem());
                            continue;
                        }
                        logger.warn("Polygon Filter does not support item {}", (Object)propertiesLocated.toString());
                    }
                    return Optional.of(polygons).filter(list -> !list.isEmpty());
                };
            }
            case WKT: {
                return string -> Optional.of(Collections.singletonList(new WktPolygonConverter().backwardConvert((String)string)));
            }
            case WKB: {
                return string -> Optional.of(Collections.singletonList(new WkbPolygonConverter().backwardConvert(WKBReader.hexToBytes(string))));
            }
        }
        logger.warn("No converter set up for {} format. Supported formats are {}", (Object)this.format, (Object)Arrays.copyOf(PolygonStringFormat.values(), PolygonStringFormat.values().length - 1));
        return string -> Optional.empty();
    }

    public String toString() {
        return this.getFormat();
    }

    static {
        logger = LoggerFactory.getLogger(PolygonStringFormat.class);
    }
}

