/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.boundary;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jtslab.SnapRoundOverlayFunctions;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.boundary.CountryBoundary;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.converters.jts.JtsMultiPolygonConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonConverter;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OceanCountryBoundaryMap
extends Command {
    private static final Command.Switch<File> BOUNDARY_MAP = new Command.Switch("boundaryMap", "The country boundary map", File::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<File> OUTPUT = new Command.Switch("output", "The ocean country boundary file to be output", File::new, Command.Optionality.REQUIRED);
    private static final int OCEAN_BOUNDARY_ZOOM_LEVEL = 3;
    private static final double JTS_SNAP_PRECISION = 1.0E-15;
    private static final Logger logger = LoggerFactory.getLogger(OceanCountryBoundaryMap.class);

    public static CountryBoundaryMap generateOceanBoundaryMap(CountryBoundaryMap boundaryMap, Iterable<SlippyTile> allTiles) {
        CountryBoundaryMap finalBoundaryMap = new CountryBoundaryMap();
        int oceanCountryCount = 0;
        logger.info("Calculating ocean boundaries");
        for (SlippyTile tile : allTiles) {
            String countryCode = String.format("O%02d", oceanCountryCount);
            Geometry countryMP = OceanCountryBoundaryMap.geometryForShard(tile.bounds(), boundaryMap);
            if (countryMP.isEmpty()) continue;
            if (countryMP instanceof Polygon) {
                finalBoundaryMap.addCountry(countryCode, (Polygon)countryMP);
            }
            if (countryMP instanceof MultiPolygon) {
                finalBoundaryMap.addCountry(countryCode, (MultiPolygon)countryMP);
            }
            ++oceanCountryCount;
        }
        logger.info("Adding country boundaries");
        JtsMultiPolygonConverter multiPolyConverter = new JtsMultiPolygonConverter();
        for (String country : boundaryMap.allCountryNames()) {
            for (CountryBoundary countryBoundary : boundaryMap.countryBoundary(country)) {
                GeometryFactory factory = new GeometryFactory();
                Set<Polygon> boundaryPolygons = multiPolyConverter.convert(countryBoundary.getBoundary());
                MultiPolygon countryMP = factory.createMultiPolygon(boundaryPolygons.toArray(new Polygon[boundaryPolygons.size()]));
                finalBoundaryMap.addCountry(country, countryMP);
            }
        }
        return finalBoundaryMap;
    }

    public static Geometry geometryForShard(Rectangle shardBounds, CountryBoundaryMap boundaryMap) {
        JtsMultiPolygonConverter multiPolyConverter = new JtsMultiPolygonConverter();
        JtsPolygonConverter polyConverter = new JtsPolygonConverter();
        GeometryFactory factory = new GeometryFactory();
        List<CountryBoundary> boundaries = boundaryMap.boundaries(shardBounds);
        Geometry shardPolyJts = polyConverter.convert(shardBounds);
        for (CountryBoundary boundary : boundaries) {
            Set<Polygon> boundaryPolygons = multiPolyConverter.convert(boundary.getBoundary());
            MultiPolygon countryMP = factory.createMultiPolygon(boundaryPolygons.toArray(new Polygon[boundaryPolygons.size()]));
            Geometry geom = SnapRoundOverlayFunctions.difference(shardPolyJts, countryMP, 1.0E-15);
            shardPolyJts = geom;
        }
        return shardPolyJts;
    }

    public static void main(String[] args) {
        new OceanCountryBoundaryMap().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        File boundaryFile = (File)command.get(BOUNDARY_MAP);
        CountryBoundaryMap boundaryMap = CountryBoundaryMap.fromPlainText(boundaryFile);
        File outputFile = (File)command.get(OUTPUT);
        Iterable<SlippyTile> allTiles = SlippyTile.allTiles(3);
        CountryBoundaryMap finalBoundaryMap = OceanCountryBoundaryMap.generateOceanBoundaryMap(boundaryMap, allTiles);
        try {
            finalBoundaryMap.writeToFile(outputFile);
            return 0;
        }
        catch (IOException e) {
            logger.error("Error while writing the boundary map to file", (Throwable)e);
            return 1;
        }
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(BOUNDARY_MAP, OUTPUT);
    }
}

