/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.boundary;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.boundary.CountryBoundary;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.converters.jts.JtsMultiPolygonToMultiPolygonConverter;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class CountryBoundaryMapPrinter
extends Command {
    private static final StringConverter<Optional<File>> OUTPUT_GETTER = value -> {
        if (!value.isEmpty()) {
            return Optional.of(new File((String)value));
        }
        return Optional.empty();
    };
    public static final Command.Switch<String> COUNTRIES = new Command.Switch<String>("countries", "The countries to extract as geojson (csv list)", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<File> INPUT = new Command.Switch("input", "The input boundaries file", File::new, Command.Optionality.REQUIRED);
    public static final Command.Switch<Optional<File>> OUTPUT_GEOJSON = new Command.Switch<Optional<File>>("geojson", "The output folder", OUTPUT_GETTER, Command.Optionality.OPTIONAL, "");
    public static final Command.Switch<Optional<File>> OUTPUT_WKT = new Command.Switch<Optional<File>>("wkt", "The output folder for WKT", OUTPUT_GETTER, Command.Optionality.OPTIONAL, "");
    private static final JtsMultiPolygonToMultiPolygonConverter JTS_MULTI_POLYGON_TO_MULTI_POLYGON_CONVERTER = new JtsMultiPolygonToMultiPolygonConverter();

    public static void main(String[] args) {
        new CountryBoundaryMapPrinter().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        File input = (File)command.get(INPUT);
        Optional geojson = (Optional)command.get(OUTPUT_GEOJSON);
        geojson.ifPresent(File::mkdirs);
        Optional wkt = (Optional)command.get(OUTPUT_WKT);
        wkt.ifPresent(File::mkdirs);
        if (!geojson.isPresent() && !wkt.isPresent()) {
            return 0;
        }
        String countries = (String)command.get(COUNTRIES);
        StringList countryList = new StringList();
        CountryBoundaryMap map = CountryBoundaryMap.fromPlainText(input);
        countryList = "*".equals(countries) ? map.countryCodesOverlappingWith(Rectangle.MAXIMUM) : StringList.split(countries, ",");
        for (String country : countryList) {
            List<CountryBoundary> boundaries = map.countryBoundary(country);
            for (int i = 0; i < boundaries.size(); ++i) {
                String name = country;
                if (i > 0) {
                    name = name + "_" + i;
                }
                MultiPolygon multiPolygon = boundaries.get(i).getBoundary();
                if (wkt.isPresent()) {
                    this.save(((File)wkt.get()).child(country + (Object)((Object)FileSuffix.WKT)), JTS_MULTI_POLYGON_TO_MULTI_POLYGON_CONVERTER.backwardConvert(multiPolygon).toText());
                }
                if (!geojson.isPresent()) continue;
                File countryFile = ((File)geojson.get()).child(name + "_boundary" + (Object)((Object)FileSuffix.GEO_JSON));
                multiPolygon.asGeoJsonFeatureCollection().save(countryFile);
            }
        }
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(INPUT, OUTPUT_GEOJSON, COUNTRIES, OUTPUT_WKT);
    }

    private void save(WritableResource output, String string) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output.write(), StandardCharsets.UTF_8));){
            writer.write(string);
        }
        catch (Exception e) {
            throw new CoreException("Could not save wkt file {}", output.getName(), e);
        }
    }
}

