/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.statistics.coverage.poi;

import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.statistics.coverage.linear.edge.OneWayEdgeCoverage;
import org.openstreetmap.atlas.geography.atlas.statistics.coverage.poi.EdgesCountCoverage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneWayEdgesCountCoverage
extends EdgesCountCoverage {
    private static final Logger logger = LoggerFactory.getLogger(OneWayEdgesCountCoverage.class);

    public OneWayEdgesCountCoverage(Atlas atlas) {
        super(logger, atlas);
    }

    public OneWayEdgesCountCoverage(Atlas atlas, Predicate<Edge> filter) {
        super(logger, atlas, filter);
    }

    @Override
    protected boolean isCounted(Edge edge) {
        return edge.containsValue("oneway", OneWayEdgeCoverage.ONE_WAYS) || edge.containsValue("junction", OneWayEdgeCoverage.ROUNDABOUT);
    }

    @Override
    protected String type() {
        return "one_way_count";
    }
}

