/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.statistics.coverage.linear.edge;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.statistics.AtlasStatistics;
import org.openstreetmap.atlas.geography.atlas.statistics.coverage.linear.edge.EdgeCoverage;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreshnessEdgeCoverage
extends EdgeCoverage {
    private static final Logger logger = LoggerFactory.getLogger(FreshnessEdgeCoverage.class);

    public FreshnessEdgeCoverage(Atlas atlas) {
        super(logger, atlas);
    }

    public FreshnessEdgeCoverage(Atlas atlas, Predicate<Edge> filter) {
        super(logger, atlas, filter);
    }

    @Override
    public Map<AtlasStatistics.StatisticKey, AtlasStatistics.StatisticValue> getStatistic() {
        Map<AtlasStatistics.StatisticKey, AtlasStatistics.StatisticValue> old = super.getStatistic();
        HashMap totals = new HashMap();
        HashMap<String, Double> monthAll = new HashMap<String, Double>();
        old.forEach((oldKey, oldValue) -> {
            StringList split = StringList.split(oldKey.getTag(), "_");
            if (split.size() == 2) {
                String tag = split.get(0);
                String month = split.get(1);
                Double allResult = oldValue.getCount();
                if (monthAll.containsKey(month)) {
                    allResult = allResult + (Double)monthAll.get(month);
                }
                monthAll.put(month, allResult);
                Double result = oldValue.getCount();
                if (totals.containsKey(tag)) {
                    result = result + (Double)totals.get(tag);
                }
                totals.put(tag, result);
            }
        });
        HashMap<AtlasStatistics.StatisticKey, AtlasStatistics.StatisticValue> result = new HashMap<AtlasStatistics.StatisticKey, AtlasStatistics.StatisticValue>();
        old.forEach((oldKey, oldValue) -> {
            StringList split = StringList.split(oldKey.getTag(), "_");
            if (split.size() == 2) {
                AtlasStatistics.StatisticKey key = new AtlasStatistics.StatisticKey(split.get(0), oldKey.getType(), split.get(1));
                AtlasStatistics.StatisticValue value = new AtlasStatistics.StatisticValue(oldValue.getCount(), (Double)totals.get(key.getTag()));
                result.put(key, value);
            }
        });
        monthAll.forEach((month, count) -> result.put(new AtlasStatistics.StatisticKey("all", this.type(), (String)month), new AtlasStatistics.StatisticValue((Double)monthAll.get(month), (Double)monthAll.values().stream().reduce((left, right) -> left + right).get())));
        return result;
    }

    @Override
    protected Set<String> getKeys(Edge edge) {
        Optional<Time> lastEditOption = edge.lastEdit();
        if (!lastEditOption.isPresent()) {
            return new HashSet<String>();
        }
        Time lastEdit = lastEditOption.get();
        String year = String.valueOf(lastEdit.year());
        String month = String.valueOf(lastEdit.month());
        HashSet<String> result = new HashSet<String>();
        result.add(edge.highwayTag().getTagValue() + "_" + year + "-" + month);
        return result;
    }

    @Override
    protected boolean isCounted(Edge item) {
        return true;
    }

    @Override
    protected String subType() {
        return "dummy";
    }

    @Override
    protected String type() {
        return "freshness";
    }
}

