/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.statistics.coverage.linear;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.statistics.coverage.linear.LinearCoverage;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusRouteLinearCoverage
extends LinearCoverage<LineItem> {
    private static final Logger logger = LoggerFactory.getLogger(BusRouteLinearCoverage.class);
    private static final StringList RELATION_TYPE_MATCHES = new StringList("route");
    private static final StringList RELATION_ROUTE_MATCHES = new StringList("bus");

    public BusRouteLinearCoverage(Atlas atlas) {
        super(logger, atlas);
    }

    public BusRouteLinearCoverage(Atlas atlas, Predicate<LineItem> filter) {
        super(logger, atlas, filter);
    }

    @Override
    protected Iterable<LineItem> getEntities() {
        return this.getAtlas().lineItems();
    }

    @Override
    protected Set<String> getKeys(LineItem item) {
        return new HashSet<String>();
    }

    @Override
    protected boolean isCounted(LineItem item) {
        for (Relation relation : item.relations()) {
            if (!relation.containsValue("type", RELATION_TYPE_MATCHES) || !relation.containsValue("route", RELATION_ROUTE_MATCHES)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String subType() {
        return "true";
    }

    @Override
    protected String type() {
        return "transit_bus_length";
    }
}

