/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.statistics;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.atlas.statistics.AtlasStatistics;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class AtlasStatisticsMerger
extends Command {
    private static final Command.Switch<List<File>> INPUT = new Command.Switch("input", "The input folder containing all the shard stat files", value -> {
        File folder = new File((String)value);
        return folder.listFilesRecursively().stream().filter(file -> file.getName().endsWith(".csv.gz")).collect(Collectors.toList());
    });
    private static final Command.Switch<File> OUTPUT = new Command.Switch("output", "The output folder for the country stats", File::new);

    public static void main(String[] args) {
        new AtlasStatisticsMerger().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        List inputs = (List)command.get(INPUT);
        File output = (File)command.get(OUTPUT);
        output.mkdirs();
        MultiMap<String, AtlasStatistics> stats = new MultiMap<String, AtlasStatistics>();
        for (File input : inputs) {
            String country2 = input.getName().split("_")[0];
            AtlasStatistics stat2 = AtlasStatistics.fromResource(input);
            stats.add(country2, stat2);
        }
        Map<String, AtlasStatistics> countryStats = stats.reduceByKey((xva$0, xva$1) -> AtlasStatistics.merge(xva$0, xva$1));
        countryStats.forEach((country, stat) -> stat.save(output.child(country + ".csv")));
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(INPUT, OUTPUT);
    }
}

