/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.TagMap;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryLine;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryPoint;

public class SimpleChangeSet {
    private final Set<TemporaryPoint> createdPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Long, TagMap> updatedPointTags = new ConcurrentHashMap<Long, TagMap>();
    private final Set<Long> deletedPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<TemporaryLine> createdLines = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Long, TagMap> updatedLineTags = new ConcurrentHashMap<Long, TagMap>();
    private final Map<Long, Set<Long>> deletedToCreatedLineMapping = new ConcurrentHashMap<Long, Set<Long>>();

    public void createDeletedToCreatedMapping(long deletedIdentifier, Set<Long> createdIdentifiers) {
        this.deletedToCreatedLineMapping.put(deletedIdentifier, createdIdentifiers);
    }

    public void createLine(TemporaryLine line) {
        this.createdLines.add(line);
    }

    public void createPoint(TemporaryPoint point) {
        this.createdPoints.add(point);
    }

    public void deletePoint(long identifier) {
        this.deletedPoints.add(identifier);
    }

    public Set<TemporaryLine> getCreatedLines() {
        return this.createdLines;
    }

    public Set<TemporaryPoint> getCreatedPoints() {
        return this.createdPoints;
    }

    public Set<Long> getDeletedPoints() {
        return this.deletedPoints;
    }

    public Map<Long, Set<Long>> getDeletedToCreatedLineMapping() {
        return this.deletedToCreatedLineMapping;
    }

    public Map<Long, TagMap> getUpdatedLineTags() {
        return this.updatedLineTags;
    }

    public Map<Long, TagMap> getUpdatedPointTags() {
        return this.updatedPointTags;
    }

    public void updateLineTags(long lineIdentifier, Map<String, String> newTags) {
        this.updatedLineTags.put(lineIdentifier, new TagMap(newTags));
    }

    public void updatePointTags(long pointIdentifier, Map<String, String> newTags) {
        this.updatedPointTags.put(pointIdentifier, new TagMap(newTags));
    }
}

